/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.meta;

import brut.yaml.YamlLine;
import brut.yaml.YamlReader;
import brut.yaml.YamlSerializable;
import brut.yaml.YamlWriter;

public class SdkInfo
implements YamlSerializable {
    private String mMinSdkVersion;
    private String mTargetSdkVersion;
    private String mMaxSdkVersion;

    public SdkInfo() {
        this.clear();
    }

    public void clear() {
        this.mMinSdkVersion = null;
        this.mTargetSdkVersion = null;
        this.mMaxSdkVersion = null;
    }

    public boolean isEmpty() {
        return this.mMinSdkVersion == null && this.mTargetSdkVersion == null && this.mMaxSdkVersion == null;
    }

    @Override
    public void readItem(YamlReader reader) {
        YamlLine line = reader.getLine();
        switch (line.getKey()) {
            case "minSdkVersion": {
                this.mMinSdkVersion = line.getValue();
                break;
            }
            case "targetSdkVersion": {
                this.mTargetSdkVersion = line.getValue();
                break;
            }
            case "maxSdkVersion": {
                this.mMaxSdkVersion = line.getValue();
            }
        }
    }

    @Override
    public void write(YamlWriter writer) {
        if (this.mMinSdkVersion != null) {
            writer.writeString("minSdkVersion", this.mMinSdkVersion);
        }
        if (this.mTargetSdkVersion != null) {
            writer.writeString("targetSdkVersion", this.mTargetSdkVersion);
        }
        if (this.mMaxSdkVersion != null) {
            writer.writeString("maxSdkVersion", this.mMaxSdkVersion);
        }
    }

    public String getMinSdkVersion() {
        return this.mMinSdkVersion;
    }

    public void setMinSdkVersion(String minSdkVersion) {
        this.mMinSdkVersion = minSdkVersion;
    }

    public String getTargetSdkVersion() {
        return this.mTargetSdkVersion;
    }

    public String getTargetSdkVersionBounded() {
        int target = SdkInfo.parseSdkInt(this.mTargetSdkVersion);
        int min = this.mMinSdkVersion != null ? SdkInfo.parseSdkInt(this.mMinSdkVersion) : 0;
        int max = this.mMaxSdkVersion != null ? SdkInfo.parseSdkInt(this.mMaxSdkVersion) : target;
        return Integer.toString(Math.max(min, Math.min(max, target)));
    }

    public void setTargetSdkVersion(String targetSdkVersion) {
        this.mTargetSdkVersion = targetSdkVersion;
    }

    public String getMaxSdkVersion() {
        return this.mMaxSdkVersion;
    }

    public void setMaxSdkVersion(String maxSdkVersion) {
        this.mMaxSdkVersion = maxSdkVersion;
    }

    public static int parseSdkInt(String sdkVersion) {
        switch (sdkVersion.toUpperCase()) {
            case "M": {
                return 23;
            }
            case "N": {
                return 24;
            }
            case "O": {
                return 26;
            }
            case "P": {
                return 28;
            }
            case "Q": {
                return 29;
            }
            case "R": {
                return 30;
            }
            case "S": {
                return 31;
            }
            case "SV2": {
                return 32;
            }
            case "T": 
            case "TIRAMISU": {
                return 33;
            }
            case "UPSIDEDOWNCAKE": 
            case "UPSIDE_DOWN_CAKE": {
                return 34;
            }
            case "VANILLAICECREAM": 
            case "VANILLA_ICE_CREAM": {
                return 35;
            }
            case "BAKLAVA": {
                return 36;
            }
            case "SDK_CUR_DEVELOPMENT": {
                return 10000;
            }
        }
        return Integer.parseInt(sdkVersion);
    }
}

