/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.res.decoder.StyledString;
import brut.androlib.res.xml.ResXmlEncoders;
import brut.util.ExtDataInput;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.logging.Logger;

public class StringBlock {
    private static final Logger LOGGER = Logger.getLogger(StringBlock.class.getName());
    private static final CharsetDecoder UTF16LE_DECODER = StandardCharsets.UTF_16LE.newDecoder();
    private static final CharsetDecoder UTF8_DECODER = StandardCharsets.UTF_8.newDecoder();
    private static final CharsetDecoder CESU8_DECODER = Charset.forName("CESU8").newDecoder();
    private static final int UTF8_FLAG = 256;
    private static final int STRING_BLOCK_HEADER_SIZE = 28;
    private int[] mStringOffsets;
    private byte[] mStrings;
    private int[] mStyleOffsets;
    private int[] mStyles;
    private boolean mIsUtf8;

    public static StringBlock readWithChunk(ExtDataInput in) throws IOException {
        long startPosition = in.position();
        int chunkType = in.readUnsignedShort();
        if (chunkType != 1) {
            throw new IOException(String.format("Invalid chunk type: expected=0x%08x, got=0x%08x", 1, chunkType));
        }
        int headerSize = in.readUnsignedShort();
        int chunkSize = in.readInt();
        return StringBlock.readWithoutChunk(in, startPosition, headerSize, chunkSize);
    }

    public static StringBlock readWithoutChunk(ExtDataInput in, long startPosition, int headerSize, int chunkSize) throws IOException {
        int remaining;
        int stringCount = in.readInt();
        int styleCount = in.readInt();
        int flags = in.readInt();
        int stringsOffset = in.readInt();
        int stylesOffset = in.readInt();
        if (headerSize > 28) {
            in.skipBytes(headerSize - 28);
        }
        StringBlock block = new StringBlock();
        block.mIsUtf8 = (flags & 0x100) != 0;
        block.mStringOffsets = in.readSafeIntArray(stringCount, startPosition + (long)stringsOffset);
        if (styleCount != 0) {
            block.mStyleOffsets = in.readSafeIntArray(styleCount, startPosition + (long)stylesOffset);
        }
        boolean hasStyles = stylesOffset != 0 && styleCount != 0;
        int size = chunkSize - stringsOffset;
        if (styleCount > 0) {
            size = stylesOffset - stringsOffset;
        }
        block.mStrings = in.readBytes(size);
        if (hasStyles) {
            size = chunkSize - stylesOffset;
            block.mStyles = in.readIntArray(size / 4);
        }
        if ((remaining = size % 4) >= 1) {
            while (remaining-- > 0) {
                in.readByte();
            }
        }
        return block;
    }

    private StringBlock() {
    }

    @VisibleForTesting
    StringBlock(byte[] strings, boolean isUTF8) {
        this.mStrings = strings;
        this.mIsUtf8 = isUTF8;
    }

    public String getString(int index) {
        int[] val;
        if (index < 0 || this.mStringOffsets == null || index >= this.mStringOffsets.length) {
            return null;
        }
        int offset = this.mStringOffsets[index];
        if (this.mIsUtf8) {
            val = StringBlock.getUtf8(this.mStrings, offset);
            offset = val[0];
        } else {
            val = StringBlock.getUtf16(this.mStrings, offset);
            offset += val[0];
        }
        int length = val[1];
        return this.decodeString(offset, length);
    }

    public String getHTML(int index) {
        String text = this.getString(index);
        if (text == null) {
            return null;
        }
        int[] style = this.getStyle(index);
        if (style == null) {
            return ResXmlEncoders.escapeXmlChars(text);
        }
        if (style[1] > text.length()) {
            return ResXmlEncoders.escapeXmlChars(text);
        }
        ArrayList<StyledString.Span> spans = new ArrayList<StyledString.Span>(style.length / 3);
        for (int i = 0; i < style.length; i += 3) {
            spans.add(new StyledString.Span(this.getString(style[i]), style[i + 1], style[i + 2]));
        }
        spans.sort(null);
        return new StyledString(text, spans).toString();
    }

    public int find(String string) {
        if (string == null) {
            return -1;
        }
        for (int i = 0; i < this.mStringOffsets.length; ++i) {
            int j;
            int offset = this.mStringOffsets[i];
            int length = StringBlock.getShort(this.mStrings, offset);
            if (length != string.length()) continue;
            for (j = 0; j < length && string.charAt(j) == StringBlock.getShort(this.mStrings, offset += 2); ++j) {
            }
            if (j != length) continue;
            return i;
        }
        return -1;
    }

    private int[] getStyle(int index) {
        int i;
        if (this.mStyleOffsets == null || this.mStyles == null || index >= this.mStyleOffsets.length) {
            return null;
        }
        int offset = this.mStyleOffsets[index] / 4;
        int count = 0;
        for (i = offset; i < this.mStyles.length && this.mStyles[i] != -1; ++i) {
            ++count;
        }
        if (count == 0 || count % 3 != 0) {
            return null;
        }
        int[] style = new int[count];
        i = offset;
        int j = 0;
        while (i < this.mStyles.length && this.mStyles[i] != -1) {
            style[j++] = this.mStyles[i++];
        }
        return style;
    }

    @VisibleForTesting
    String decodeString(int offset, int length) {
        block6: {
            try {
                ByteBuffer wrappedBuffer = ByteBuffer.wrap(this.mStrings, offset, length);
                return (this.mIsUtf8 ? UTF8_DECODER : UTF16LE_DECODER).decode(wrappedBuffer).toString();
            }
            catch (CharacterCodingException ex) {
                if (!this.mIsUtf8) {
                    LOGGER.warning("Failed to decode a string at offset " + offset + " of length " + length);
                    return null;
                }
            }
            catch (IndexOutOfBoundsException ex) {
                if (this.mIsUtf8) break block6;
                LOGGER.warning("String extends outside of pool at  " + offset + " of length " + length);
                return null;
            }
        }
        try {
            ByteBuffer wrappedBufferRetry = ByteBuffer.wrap(this.mStrings, offset, length);
            return CESU8_DECODER.decode(wrappedBufferRetry).toString();
        }
        catch (CharacterCodingException ex) {
            LOGGER.warning("Failed to decode a string with CESU-8 decoder.");
            return null;
        }
    }

    private static int getShort(byte[] array, int offset) {
        return (array[offset + 1] & 0xFF) << 8 | array[offset] & 0xFF;
    }

    private static int[] getUtf8(byte[] array, int offset) {
        int length;
        int val = array[offset];
        offset = (val & 0x80) != 0 ? (offset += 2) : ++offset;
        val = array[offset];
        ++offset;
        if ((val & 0x80) != 0) {
            int low = array[offset] & 0xFF;
            length = ((val & 0x7F) << 8) + low;
        } else {
            length = val;
        }
        return new int[]{++offset, length};
    }

    private static int[] getUtf16(byte[] array, int offset) {
        int val = (array[offset + 1] & 0xFF) << 8 | array[offset] & 0xFF;
        if ((val & 0x8000) != 0) {
            int high = (array[offset + 3] & 0xFF) << 8;
            int low = array[offset + 2] & 0xFF;
            int len_value = ((val & Short.MAX_VALUE) << 16) + high + low;
            return new int[]{4, len_value * 2};
        }
        return new int[]{2, val * 2};
    }
}

