/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.util;

import java.util.Iterator;

public class ChainedIterable<T>
implements Iterable<T> {
    Iterable<T> iterableA;
    Iterable<T> iterableB;

    public ChainedIterable(Iterable<T> iterableA, Iterable<T> iterableB) {
        this.iterableA = iterableA;
        this.iterableB = iterableB;
    }

    @Override
    public final Iterator<T> iterator() {
        return new ChainedIterator<T>(this.iterableA.iterator(), this.iterableB.iterator());
    }

    public static class ChainedIterator<U>
    implements Iterator<U> {
        Iterator<U> iteratorA;
        Iterator<U> iteratorB;

        public ChainedIterator(Iterator<U> iteratorA, Iterator<U> iteratorB) {
            this.iteratorA = iteratorA;
            this.iteratorB = iteratorB;
        }

        @Override
        public final boolean hasNext() {
            return this.iteratorA.hasNext() || this.iteratorB.hasNext();
        }

        @Override
        public final U next() {
            if (this.iteratorA.hasNext()) {
                return this.iteratorA.next();
            }
            return this.iteratorB.next();
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

