/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.expr.InvokeExpr;
import com.googlecode.dex2jar.ir.expr.Local;
import com.googlecode.dex2jar.ir.expr.Value;
import com.googlecode.dex2jar.ir.stmt.AssignStmt;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.ts.Cfg;
import com.googlecode.dex2jar.ir.ts.StatedTransformer;
import com.googlecode.dex2jar.ir.ts.UniqueQueue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class AggTransformer
extends StatedTransformer {
    private static final MergeResult FAIL = new MergeResult();
    private static final MergeResult SUCCESS = new MergeResult();

    @Override
    public boolean transformReportChanged(IrMethod method) {
        boolean changed = false;
        HashSet<Stmt> locationSensitiveStmts = new HashSet<Stmt>();
        changed = this.simpleMergeLocals(method, changed, locationSensitiveStmts);
        if (locationSensitiveStmts.isEmpty()) {
            return changed;
        }
        ReplaceX replaceX = new ReplaceX();
        UniqueQueue q = new UniqueQueue();
        q.addAll(locationSensitiveStmts);
        block5: while (!q.isEmpty()) {
            Stmt stmt = (Stmt)q.poll();
            Local local = (Local)stmt.getOp1();
            Stmt next = stmt.getNext();
            switch (next.st) {
                case LABEL: 
                case GOTO: 
                case IDENTITY: 
                case FILL_ARRAY_DATA: 
                case NOP: 
                case RETURN_VOID: {
                    continue block5;
                }
            }
            try {
                AggTransformer.localCanExecFirst(local, next);
                throw new RuntimeException();
            }
            catch (MergeResult e) {
                if (e != SUCCESS) continue;
                replaceX.local = local;
                replaceX.replaceWith = stmt.getOp2();
                method.locals.remove(local);
                method.stmts.remove(stmt);
                Cfg.travelMod(next, (Cfg.TravelCallBack)replaceX, false);
                Stmt pre = next.getPre();
                if (pre == null || !locationSensitiveStmts.contains(pre)) continue;
                q.add(pre);
            }
        }
        return changed;
    }

    private static void localCanExecFirst(Local local, Stmt target) throws MergeResult {
        block0 : switch (target.et) {
            case E0: 
            case En: {
                throw FAIL;
            }
            case E1: {
                AggTransformer.localCanExecFirst(local, target.getOp());
                break;
            }
            case E2: {
                AssignStmt as = (AssignStmt)target;
                Value op1 = as.getOp1();
                Value op2 = as.getOp2();
                switch (op1.vt) {
                    case LOCAL: {
                        AggTransformer.localCanExecFirst(local, op2);
                        break block0;
                    }
                    case FIELD: {
                        AggTransformer.localCanExecFirst(local, op1.getOp());
                    }
                    case STATIC_FIELD: {
                        AggTransformer.localCanExecFirst(local, op2);
                        break block0;
                    }
                    case ARRAY: {
                        AggTransformer.localCanExecFirst(local, op1.getOp1());
                        AggTransformer.localCanExecFirst(local, op1.getOp2());
                        AggTransformer.localCanExecFirst(local, op2);
                        break block0;
                    }
                }
                break;
            }
        }
        throw FAIL;
    }

    private static void localCanExecFirst(Local local, Value op) throws MergeResult {
        InvokeExpr ie;
        switch (op.et) {
            case E0: {
                if (local.vt != Value.VT.LOCAL || op != local) break;
                throw SUCCESS;
            }
            case E1: {
                AggTransformer.localCanExecFirst(local, op.getOp());
                break;
            }
            case E2: {
                AggTransformer.localCanExecFirst(local, op.getOp1());
                AggTransformer.localCanExecFirst(local, op.getOp2());
                break;
            }
            case En: {
                for (Value v : op.getOps()) {
                    AggTransformer.localCanExecFirst(local, v);
                }
                break;
            }
        }
        boolean shouldExclude = false;
        if (op.vt == Value.VT.INVOKE_STATIC && (ie = (InvokeExpr)op).getName().equals("valueOf") && ie.getOwner().startsWith("Ljava/lang/") && ie.getArgs().length == 1 && ie.getArgs()[0].length() == 1) {
            shouldExclude = true;
        }
        if (!AggTransformer.isLocationInsensitive(op.vt) && !shouldExclude) {
            throw FAIL;
        }
    }

    private boolean simpleMergeLocals(IrMethod method, boolean changed, Set<Stmt> locationSensitiveStmts) {
        if (method.locals.isEmpty()) {
            return false;
        }
        int[] readCounts = Cfg.countLocalReads(method);
        Set<Local> useInPhi = this.collectLocalUsedInPhi(method);
        final HashMap<Local, Value> toReplace = new HashMap<Local, Value>();
        Iterator<Stmt> it = method.stmts.iterator();
        while (it.hasNext()) {
            Local local;
            Stmt p = it.next();
            if (p.st != Stmt.ST.ASSIGN || p.getOp1().vt != Value.VT.LOCAL || useInPhi.contains(local = (Local)p.getOp1()) || readCounts[local.lsIndex] >= 2) continue;
            Value op2 = p.getOp2();
            if (AggTransformer.isLocationInsensitive(op2)) {
                method.locals.remove(local);
                toReplace.put(local, op2);
                it.remove();
                changed = true;
                continue;
            }
            locationSensitiveStmts.add(p);
        }
        Cfg.TravelCallBack tcb = new Cfg.TravelCallBack(){
            final /* synthetic */ AggTransformer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Value onAssign(Local v, AssignStmt as) {
                return v;
            }

            @Override
            public Value onUse(Local v) {
                Value v2 = (Value)toReplace.get(v);
                if (v2 != null) {
                    return v2;
                }
                return v;
            }
        };
        this.modReplace(toReplace, tcb);
        Cfg.travelMod(method.stmts, tcb, false);
        return changed;
    }

    private Set<Local> collectLocalUsedInPhi(IrMethod method) {
        HashSet<Local> useInPhi = new HashSet<Local>();
        if (method.phiLabels != null) {
            for (LabelStmt labelStmt : method.phiLabels) {
                if (labelStmt.phis == null) continue;
                for (AssignStmt phi : labelStmt.phis) {
                    useInPhi.add((Local)phi.getOp1());
                    for (Value op : phi.getOp2().getOps()) {
                        useInPhi.add((Local)op);
                    }
                }
            }
        }
        return useInPhi;
    }

    private void modReplace(Map<Local, Value> toReplace, Cfg.TravelCallBack tcb) {
        for (Map.Entry<Local, Value> e : toReplace.entrySet()) {
            Value v = e.getValue();
            if (v.vt == Value.VT.LOCAL) {
                Value v2;
                while ((v2 = toReplace.get(v)) != null) {
                    v = v2;
                    if (v.vt == Value.VT.LOCAL) continue;
                    break;
                }
                e.setValue(v);
                continue;
            }
            Cfg.travelMod(v, tcb);
        }
    }

    static boolean isLocationInsensitive(Value.VT vt) {
        switch (vt) {
            case LOCAL: 
            case CONSTANT: 
            case ADD: 
            case SUB: 
            case MUL: 
            case REM: 
            case AND: 
            case OR: 
            case XOR: 
            case SHL: 
            case SHR: 
            case USHR: 
            case GE: 
            case GT: 
            case LE: 
            case LT: 
            case EQ: 
            case NE: 
            case DCMPG: 
            case DCMPL: 
            case LCMP: 
            case FCMPG: 
            case FCMPL: 
            case NOT: {
                return true;
            }
        }
        return false;
    }

    static boolean isLocationInsensitive(Value op) {
        switch (op.et) {
            case E0: {
                return AggTransformer.isLocationInsensitive(op.vt);
            }
            case E1: {
                return AggTransformer.isLocationInsensitive(op.vt) && AggTransformer.isLocationInsensitive(op.getOp());
            }
            case E2: {
                return AggTransformer.isLocationInsensitive(op.vt) && AggTransformer.isLocationInsensitive(op.getOp1()) && AggTransformer.isLocationInsensitive(op.getOp2());
            }
            case En: {
                if (op.vt == Value.VT.INVOKE_STATIC) {
                    InvokeExpr ie = (InvokeExpr)op;
                    if (ie.getName().equals("valueOf") && ie.getOwner().startsWith("Ljava/lang/") && ie.getArgs().length == 1 && ie.getArgs()[0].length() == 1) {
                        for (Value v : op.getOps()) {
                            if (AggTransformer.isLocationInsensitive(v)) continue;
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
                if (AggTransformer.isLocationInsensitive(op.vt)) {
                    for (Value v : op.getOps()) {
                        if (AggTransformer.isLocationInsensitive(v)) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    static class ReplaceX
    implements Cfg.TravelCallBack {
        Local local;
        Value replaceWith;

        ReplaceX() {
        }

        @Override
        public Value onAssign(Local v, AssignStmt as) {
            return v;
        }

        @Override
        public Value onUse(Local v) {
            if (v == this.local) {
                return this.replaceWith;
            }
            return v;
        }
    }

    static class MergeResult
    extends Throwable {
        private static final long serialVersionUID = -1563502983848655360L;

        MergeResult() {
        }
    }
}

