/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts;

import com.googlecode.dex2jar.ir.ET;
import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.StmtTraveler;
import com.googlecode.dex2jar.ir.expr.Exprs;
import com.googlecode.dex2jar.ir.expr.InvokeExpr;
import com.googlecode.dex2jar.ir.expr.Local;
import com.googlecode.dex2jar.ir.expr.NewExpr;
import com.googlecode.dex2jar.ir.expr.Value;
import com.googlecode.dex2jar.ir.stmt.AssignStmt;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.stmt.Stmts;
import com.googlecode.dex2jar.ir.ts.Cfg;
import com.googlecode.dex2jar.ir.ts.Transformer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class NewTransformer
implements Transformer {
    static final Vx IGNORED = new Vx(null, true);

    @Override
    public void transform(IrMethod method) {
        this.replaceX(method);
        this.replaceAST(method);
    }

    void replaceX(IrMethod method) {
        HashMap<Local, TObject> init = new HashMap<Local, TObject>();
        for (Stmt p : method.stmts) {
            if (p.st != Stmt.ST.ASSIGN || p.getOp1().vt != Value.VT.LOCAL || p.getOp2().vt != Value.VT.NEW) continue;
            Local local = (Local)p.getOp1();
            init.put(local, new TObject(local, (AssignStmt)p));
        }
        if (!init.isEmpty()) {
            int size = Cfg.reIndexLocal(method);
            this.makeSureUsedBeforeConstructor(method, init, size);
            if (!init.isEmpty()) {
                this.replace0(method, init, size);
            }
            for (Stmt stmt : method.stmts) {
                stmt.frame = null;
            }
        }
    }

    void replaceAST(IrMethod method) {
        Iterator<Stmt> it = method.stmts.iterator();
        while (it.hasNext()) {
            NewExpr newExpr;
            Stmt p = it.next();
            InvokeExpr ie = this.findInvokeExpr(p);
            if (ie == null || !"<init>".equals(ie.getName()) || !"V".equals(ie.getRet())) continue;
            Value[] orgOps = ie.getOps();
            if (orgOps[0].vt != Value.VT.NEW || (newExpr = (NewExpr)ie.getOps()[0]) == null) continue;
            Value[] nOps = Arrays.copyOfRange(orgOps, 1, orgOps.length);
            InvokeExpr invokeNew = Exprs.nInvokeNew(nOps, ie.getArgs(), ie.getOwner());
            method.stmts.insertBefore(p, Stmts.nVoidInvoke(invokeNew));
            it.remove();
        }
    }

    void replace0(IrMethod method, Map<Local, TObject> init, int size) {
        HashSet<Local> toDelete = new HashSet<Local>();
        Local[] locals = new Local[size];
        Iterator<Object> iterator = method.locals.iterator();
        while (iterator.hasNext()) {
            Local local;
            locals[local.lsIndex] = local = iterator.next();
        }
        for (TObject obj : init.values()) {
            Vx[] frame = (Vx[])obj.invokeStmt.frame;
            for (int i = 0; i < frame.length; ++i) {
                Vx s = frame[i];
                if (s == null || s.obj != obj) continue;
                toDelete.add(locals[i]);
            }
        }
        Iterator<Stmt> it = method.stmts.iterator();
        while (it.hasNext()) {
            Stmt p = it.next();
            if (p.st != Stmt.ST.ASSIGN || p.getOp1().vt != Value.VT.LOCAL || !toDelete.contains((Local)p.getOp1())) continue;
            it.remove();
        }
        for (TObject obj : init.values()) {
            Vx[] frame = (Vx[])obj.invokeStmt.frame;
            for (int i = 0; i < frame.length; ++i) {
                Local b;
                Vx s = frame[i];
                if (s == null || s.obj != obj || (b = locals[i]) == obj.local) continue;
                method.stmts.insertAfter(obj.invokeStmt, Stmts.nAssign(b, obj.local));
            }
            InvokeExpr ie = this.findInvokeExpr(obj.invokeStmt);
            Value[] orgOps = ie.getOps();
            Value[] nOps = Arrays.copyOfRange(orgOps, 1, orgOps.length);
            InvokeExpr invokeNew = Exprs.nInvokeNew(nOps, ie.getArgs(), ie.getOwner());
            method.stmts.replace(obj.invokeStmt, Stmts.nAssign(obj.local, invokeNew));
        }
    }

    void makeSureUsedBeforeConstructor(IrMethod method, final Map<Local, TObject> init, final int size) {
        Cfg.createCFG(method);
        Cfg.dfs(method.stmts, new Cfg.FrameVisitor<Vx[]>(){
            boolean keepFrame = false;
            final Vx[] tmp = new Vx[size];
            final StmtTraveler stmtTraveler = new StmtTraveler(this){
                Stmt current;
                final /* synthetic */ 1 this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public Stmt travel(Stmt stmt) {
                    this.current = stmt;
                    if (stmt.et == ET.E2 && stmt.getOp1().vt == Value.VT.LOCAL) {
                        Local op1 = (Local)stmt.getOp1();
                        if (stmt.getOp2().vt == Value.VT.LOCAL) {
                            Local op2 = (Local)stmt.getOp2();
                            this.this$1.tmp[op1.lsIndex] = this.this$1.tmp[op2.lsIndex];
                            return stmt;
                        }
                        if (stmt.getOp2().vt == Value.VT.NEW) {
                            this.this$1.tmp[op1.lsIndex] = new Vx((TObject)init.get(op1), false);
                            return stmt;
                        }
                        this.travel(stmt.getOp2());
                        this.this$1.tmp[op1.lsIndex] = IGNORED;
                        return stmt;
                    }
                    if (stmt.st == Stmt.ST.LABEL) {
                        LabelStmt labelStmt = (LabelStmt)stmt;
                        if (labelStmt.phis != null) {
                            for (AssignStmt phi : labelStmt.phis) {
                                Local local = (Local)phi.getOp1();
                                this.this$1.tmp[local.lsIndex] = IGNORED;
                            }
                        }
                        return stmt;
                    }
                    return super.travel(stmt);
                }

                @Override
                public Value travel(Value op) {
                    InvokeExpr ie;
                    if (op.vt == Value.VT.INVOKE_SPECIAL && op.getOps().length >= 1 && "<init>".equals((ie = (InvokeExpr)op).getName())) {
                        Value thiz = op.getOps()[0];
                        if (thiz.vt == Value.VT.LOCAL) {
                            Local local = (Local)thiz;
                            Vx vx = this.this$1.tmp[local.lsIndex];
                            TObject object = vx.obj;
                            if (object != null) {
                                if (object.invokeStmt != null) {
                                    object.useBeforeInit = true;
                                } else {
                                    vx.init = true;
                                    object.invokeStmt = this.current;
                                    for (int i = 0; i < this.this$1.tmp.length; ++i) {
                                        Vx s = this.this$1.tmp[i];
                                        if (s == null || s.obj != object) continue;
                                        this.this$1.tmp[i] = IGNORED;
                                    }
                                    this.this$1.keepFrame = true;
                                }
                            }
                        }
                    }
                    op = super.travel(op);
                    if (op.vt == Value.VT.LOCAL) {
                        this.this$1.use((Local)op);
                    }
                    return op;
                }
            };
            final /* synthetic */ NewTransformer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Vx[] merge(Vx[] srcFrame, Vx[] distFrame, Stmt src, Stmt dist) {
                List<AssignStmt> phis;
                if (distFrame == null) {
                    distFrame = new Vx[size];
                    System.arraycopy(srcFrame, 0, distFrame, 0, size);
                } else {
                    for (int i = 0; i < size; ++i) {
                        Vx s = srcFrame[i];
                        Vx d = distFrame[i];
                        if (s == null) continue;
                        if (d == null) {
                            distFrame[i] = s;
                            continue;
                        }
                        if (s == d) continue;
                        TObject obj = s.obj;
                        if (obj != null) {
                            obj.useBeforeInit = true;
                        }
                        if ((obj = d.obj) == null) continue;
                        obj.useBeforeInit = true;
                    }
                }
                if (dist.st == Stmt.ST.LABEL && (phis = ((LabelStmt)dist).phis) != null && !phis.isEmpty()) {
                    for (AssignStmt phi : phis) {
                        for (Value value : phi.getOp2().getOps()) {
                            TObject obj;
                            Local local = (Local)value;
                            int i = local.lsIndex;
                            Vx s = srcFrame[i];
                            Vx d = distFrame[i];
                            if (d != null) {
                                if (d.init || (obj = d.obj) == null) continue;
                                obj.useBeforeInit = true;
                                continue;
                            }
                            if (s == null || s.init || (obj = s.obj) == null) continue;
                            obj.useBeforeInit = true;
                        }
                    }
                }
                return distFrame;
            }

            @Override
            public Vx[] initFirstFrame(Stmt first) {
                return new Vx[size];
            }

            @Override
            public Vx[] exec(Vx[] frame, Stmt stmt) {
                this.keepFrame = false;
                System.arraycopy(frame, 0, this.tmp, 0, size);
                this.stmtTraveler.travel(stmt);
                if (stmt.cfgFroms.size() > 1) {
                    this.keepFrame = true;
                }
                if (!this.keepFrame) {
                    stmt.frame = null;
                }
                return this.tmp;
            }

            void use(Local local) {
                Vx vx = this.tmp[local.lsIndex];
                if (!vx.init) {
                    TObject object = vx.obj;
                    if (object != null) {
                        object.useBeforeInit = true;
                    }
                    this.tmp[local.lsIndex] = IGNORED;
                }
            }
        });
        Iterator<Map.Entry<Local, TObject>> iterator = init.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Local, TObject> e = iterator.next();
            boolean keep = true;
            TObject obj = e.getValue();
            if (obj.useBeforeInit) {
                keep = false;
            }
            if (obj.invokeStmt == null) {
                keep = false;
            }
            if (keep) continue;
            iterator.remove();
        }
    }

    InvokeExpr findInvokeExpr(Stmt p) {
        Value op;
        InvokeExpr ie = null;
        if (p.st == Stmt.ST.ASSIGN) {
            if (p.getOp2().vt == Value.VT.INVOKE_SPECIAL) {
                ie = (InvokeExpr)p.getOp2();
            }
        } else if (p.st == Stmt.ST.VOID_INVOKE && (op = p.getOp()) instanceof InvokeExpr) {
            ie = (InvokeExpr)op;
        }
        return ie;
    }

    static class TObject {
        public Stmt invokeStmt;
        Local local;
        boolean useBeforeInit;
        private final AssignStmt init;

        TObject(Local local, AssignStmt init) {
            this.local = local;
            this.init = init;
        }
    }

    static class Vx {
        boolean init;
        TObject obj;

        Vx(TObject obj, boolean init) {
            this.obj = obj;
            this.init = init;
        }
    }
}

