/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.StmtSearcher;
import com.googlecode.dex2jar.ir.StmtTraveler;
import com.googlecode.dex2jar.ir.expr.Constant;
import com.googlecode.dex2jar.ir.expr.Exprs;
import com.googlecode.dex2jar.ir.expr.Local;
import com.googlecode.dex2jar.ir.expr.Value;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.stmt.Stmts;
import com.googlecode.dex2jar.ir.ts.StatedTransformer;

public class NpeTransformer
extends StatedTransformer {
    private static final MustThrowException NPE = new MustThrowException();
    private static final MustThrowException DIVE = new MustThrowException();
    private static final MustThrowException NEGATIVE_ARRAY_SIZE = new MustThrowException();

    @Override
    public boolean transformReportChanged(IrMethod method) {
        boolean changed = false;
        if (method.locals.isEmpty()) {
            return false;
        }
        StmtSearcher st = new StmtSearcher(){

            @Override
            public void travel(Stmt stmt) {
                if (stmt.st == Stmt.ST.FILL_ARRAY_DATA && NpeTransformer.isNull(stmt.getOp1())) {
                    throw NPE;
                }
                super.travel(stmt);
            }

            @Override
            public void travel(Value op) {
                switch (op.vt) {
                    case INVOKE_VIRTUAL: 
                    case INVOKE_SPECIAL: 
                    case INVOKE_INTERFACE: {
                        if (!NpeTransformer.isNull(op.getOps()[0])) break;
                        throw NPE;
                    }
                    case ARRAY: {
                        if (!NpeTransformer.isNull(op.getOp1())) break;
                        throw NPE;
                    }
                    case FIELD: {
                        if (!NpeTransformer.isNull(op.getOp())) break;
                        throw NPE;
                    }
                    case IDIV: {
                        if (op.getOp2().vt != Value.VT.CONSTANT) break;
                        Constant constant = (Constant)op.getOp2();
                        if (((Number)constant.value).intValue() != 0) break;
                        throw DIVE;
                    }
                    case LDIV: {
                        if (op.getOp2().vt != Value.VT.CONSTANT) break;
                        Constant constant = (Constant)op.getOp2();
                        if (((Number)constant.value).longValue() != 0L) break;
                        throw DIVE;
                    }
                    case NEW_ARRAY: {
                        if (op.getOp().vt != Value.VT.CONSTANT) break;
                        Constant constant = (Constant)op.getOp();
                        if (((Number)constant.value).intValue() >= 0) break;
                        throw NEGATIVE_ARRAY_SIZE;
                    }
                    case NEW_MUTI_ARRAY: {
                        for (Value size : op.getOps()) {
                            if (size.vt != Value.VT.CONSTANT) continue;
                            Constant constant = (Constant)size;
                            if (((Number)constant.value).intValue() >= 0) continue;
                            throw NEGATIVE_ARRAY_SIZE;
                        }
                        break;
                    }
                }
            }
        };
        Stmt p = method.stmts.getFirst();
        while (p != null) {
            try {
                st.travel(p);
                p = p.getNext();
            }
            catch (MustThrowException e) {
                this.replace(method, p);
                Stmt q = p.getNext();
                method.stmts.remove(p);
                changed = true;
                p = q;
            }
        }
        return changed;
    }

    private void replace(final IrMethod m, final Stmt p) {
        block17: {
            StmtTraveler traveler = new StmtTraveler(this){
                final /* synthetic */ NpeTransformer this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Value travel(Value op) {
                    switch (op.vt) {
                        case INVOKE_VIRTUAL: 
                        case INVOKE_SPECIAL: 
                        case INVOKE_INTERFACE: {
                            Value[] valueArray = op.getOps();
                            if (!NpeTransformer.isNull(valueArray[0])) break;
                            for (int i = 1; i < valueArray.length; ++i) {
                                this.travel(valueArray[i]);
                            }
                            throw NPE;
                        }
                        case ARRAY: {
                            if (!NpeTransformer.isNull(op.getOp1())) break;
                            this.travel(op.getOp2());
                            throw NPE;
                        }
                        case FIELD: {
                            if (!NpeTransformer.isNull(op.getOp())) break;
                            throw NPE;
                        }
                        case IDIV: {
                            if (op.getOp2().vt != Value.VT.CONSTANT) break;
                            Constant constant = (Constant)op.getOp2();
                            if (((Number)constant.value).intValue() != 0) break;
                            this.travel(op.getOp1());
                            throw DIVE;
                        }
                        case LDIV: {
                            if (op.getOp2().vt != Value.VT.CONSTANT) break;
                            Constant constant = (Constant)op.getOp2();
                            if (((Number)constant.value).longValue() != 0L) break;
                            this.travel(op.getOp1());
                            throw DIVE;
                        }
                        case NEW_ARRAY: {
                            if (op.getOp().vt != Value.VT.CONSTANT) break;
                            Constant constant = (Constant)op.getOp();
                            if (((Number)constant.value).intValue() >= 0) break;
                            throw NEGATIVE_ARRAY_SIZE;
                        }
                        case NEW_MUTI_ARRAY: {
                            for (Value size : op.getOps()) {
                                if (size.vt != Value.VT.CONSTANT) continue;
                                Constant constant = (Constant)size;
                                if (((Number)constant.value).intValue() < 0) {
                                    throw NEGATIVE_ARRAY_SIZE;
                                }
                                this.travel(size);
                            }
                            break;
                        }
                    }
                    Value value = super.travel(op);
                    if (value.vt == Value.VT.LOCAL || value.vt == Value.VT.CONSTANT) {
                        return value;
                    }
                    Local local = new Local();
                    m.locals.add(local);
                    m.stmts.insertBefore(p, Stmts.nAssign(local, value));
                    return local;
                }
            };
            try {
                block1 : switch (p.et) {
                    case E0: {
                        break;
                    }
                    case E1: {
                        traveler.travel(p.getOp());
                        break;
                    }
                    case E2: {
                        if (p.st == Stmt.ST.ASSIGN) {
                            switch (p.getOp1().vt) {
                                case ARRAY: {
                                    traveler.travel(p.getOp1().getOp1());
                                    traveler.travel(p.getOp1().getOp2());
                                    traveler.travel(p.getOp2());
                                    break block1;
                                }
                                case FIELD: {
                                    traveler.travel(p.getOp1().getOp());
                                    traveler.travel(p.getOp2());
                                    break block1;
                                }
                                case STATIC_FIELD: 
                                case LOCAL: {
                                    traveler.travel(p.getOp2());
                                    break block1;
                                }
                            }
                            break;
                        }
                        if (p.st != Stmt.ST.FILL_ARRAY_DATA) break;
                        if (NpeTransformer.isNull(p.getOp1())) {
                            throw NPE;
                        }
                        traveler.travel(p.getOp1());
                        break;
                    }
                    case En: {
                        break;
                    }
                }
            }
            catch (MustThrowException e) {
                if (e == NPE) {
                    m.stmts.insertBefore(p, Stmts.nThrow(Exprs.nInvokeNew(new Value[0], new String[0], "Ljava/lang/NullPointerException;")));
                }
                if (e == DIVE) {
                    m.stmts.insertBefore(p, Stmts.nThrow(Exprs.nInvokeNew(new Value[]{Exprs.nString("divide by zero")}, new String[]{"Ljava/lang/String;"}, "Ljava/lang/ArithmeticException;")));
                }
                if (e != NEGATIVE_ARRAY_SIZE) break block17;
                m.stmts.insertBefore(p, Stmts.nThrow(Exprs.nInvokeNew(new Value[0], new String[0], "Ljava/lang/NegativeArraySizeException;")));
            }
        }
    }

    static boolean isNull(Value v) {
        if (v.vt == Value.VT.CONSTANT) {
            Constant cst = (Constant)v;
            if (Constant.NULL.equals(cst.value)) {
                return true;
            }
            if (cst.value instanceof Number) {
                return ((Number)cst.value).intValue() == 0;
            }
        }
        return false;
    }

    private static class MustThrowException
    extends RuntimeException {
        private static final long serialVersionUID = 7501197864919305696L;

        private MustThrowException() {
        }
    }
}

