/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts.array;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.StmtTraveler;
import com.googlecode.dex2jar.ir.expr.ArrayExpr;
import com.googlecode.dex2jar.ir.expr.Constant;
import com.googlecode.dex2jar.ir.expr.Exprs;
import com.googlecode.dex2jar.ir.expr.FilledArrayExpr;
import com.googlecode.dex2jar.ir.expr.Local;
import com.googlecode.dex2jar.ir.expr.Value;
import com.googlecode.dex2jar.ir.stmt.AssignStmt;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.stmt.Stmts;
import com.googlecode.dex2jar.ir.ts.Cfg;
import com.googlecode.dex2jar.ir.ts.StatedTransformer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ArrayElementTransformer
extends StatedTransformer {
    @Override
    public boolean transformReportChanged(IrMethod method) {
        Set<Local> arrays = this.searchForArrayObject(method);
        if (arrays.isEmpty()) {
            return false;
        }
        for (Local local : method.locals) {
            local.lsIndex = -1;
        }
        int i = 0;
        for (Local local : arrays) {
            local.lsIndex = i++;
        }
        final int n = i;
        Cfg.createCFG(method);
        final ArrayList values = new ArrayList();
        final ArrayList used = new ArrayList();
        Cfg.dfs(method.stmts, new Cfg.FrameVisitor<ArrayValue[]>(){
            final Set<Integer> phis = new HashSet<Integer>();
            ArrayValue[] tmp = new ArrayValue[n];
            Stmt currentStmt;
            final /* synthetic */ ArrayElementTransformer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public ArrayValue[] merge(ArrayValue[] srcFrame, ArrayValue[] distFrame, Stmt src, Stmt dist) {
                ArrayValue aov;
                ArrayValue arc;
                if (dist.st == Stmt.ST.LABEL) {
                    LabelStmt labelStmt = (LabelStmt)dist;
                    if (labelStmt.phis != null) {
                        for (AssignStmt phi : labelStmt.phis) {
                            int idx = ((Local)phi.getOp1()).lsIndex;
                            if (idx < 0) continue;
                            this.phis.add(idx);
                        }
                    }
                }
                if (distFrame == null) {
                    distFrame = new ArrayValue[n];
                    for (int i = 0; i < n; ++i) {
                        if (this.phis.contains(i)) {
                            ArrayValue aov2 = new ArrayValue();
                            values.add(aov2);
                            aov2.s = ArrayValue.S.UNKNOWN;
                            aov2.indexType = ArrayValue.IndexType.NONE;
                            aov2.stmt = dist;
                            distFrame[i] = aov2;
                            continue;
                        }
                        arc = srcFrame[i];
                        if (arc == null) continue;
                        aov = new ArrayValue();
                        values.add(aov);
                        aov.s = ArrayValue.S.INHERIT;
                        aov.indexType = ArrayValue.IndexType.NONE;
                        aov.stmt = dist;
                        aov.parent = arc;
                        distFrame[i] = aov;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        if (this.phis.contains(i)) continue;
                        arc = srcFrame[i];
                        aov = distFrame[i];
                        if (arc == null || aov == null) continue;
                        if (aov.parent == null) {
                            aov.parent = arc;
                            continue;
                        }
                        if (aov.parent.equals(arc)) continue;
                        if (aov.otherParents == null) {
                            aov.otherParents = new HashSet<ArrayValue>();
                        }
                        aov.otherParents.add(arc);
                    }
                }
                this.phis.clear();
                return distFrame;
            }

            @Override
            public ArrayValue[] initFirstFrame(Stmt first) {
                return new ArrayValue[n];
            }

            @Override
            public ArrayValue[] exec(ArrayValue[] frame, Stmt stmt) {
                this.currentStmt = stmt;
                System.arraycopy(frame, 0, this.tmp, 0, n);
                if (stmt.st == Stmt.ST.ASSIGN) {
                    if (stmt.getOp1().vt == Value.VT.LOCAL) {
                        Local local = (Local)stmt.getOp1();
                        this.use(stmt.getOp2());
                        if (local.lsIndex >= 0) {
                            Value op2 = stmt.getOp2();
                            if (op2.vt == Value.VT.NEW_ARRAY) {
                                ArrayValue av = new ArrayValue();
                                av.s = ArrayValue.S.DEFAULT;
                                av.size = op2.getOp();
                                values.add(av);
                                this.tmp[local.lsIndex] = av;
                            } else if (op2.vt == Value.VT.FILLED_ARRAY) {
                                ArrayValue av = new ArrayValue();
                                av.s = ArrayValue.S.DEFAULT;
                                av.indexType = ArrayValue.IndexType.CONST;
                                av.stmt = stmt;
                                FilledArrayExpr fae = (FilledArrayExpr)stmt.getOp2();
                                av.size = Exprs.nInt(fae.getOps().length);
                                Value[] ops = fae.getOps();
                                for (int i = 0; i < ops.length; ++i) {
                                    av.elements1.put(i, ops[i]);
                                }
                                values.add(av);
                                this.tmp[local.lsIndex] = av;
                            } else if (op2.vt == Value.VT.CONSTANT) {
                                Object cst = ((Constant)op2).value;
                                if (cst != null && !cst.equals(Constant.NULL) && cst.getClass().isArray()) {
                                    ArrayValue av = new ArrayValue();
                                    av.s = ArrayValue.S.DEFAULT;
                                    av.indexType = ArrayValue.IndexType.CONST;
                                    av.stmt = stmt;
                                    int size = Array.getLength(cst);
                                    av.size = Exprs.nInt(size);
                                    for (int i = 0; i < size; ++i) {
                                        av.elements1.put(i, Exprs.nConstant(Array.get(cst, size)));
                                    }
                                    values.add(av);
                                    this.tmp[local.lsIndex] = av;
                                } else {
                                    ArrayValue av = new ArrayValue();
                                    values.add(av);
                                    av.s = ArrayValue.S.UNKNOWN;
                                    av.indexType = ArrayValue.IndexType.NONE;
                                    av.stmt = stmt;
                                    this.tmp[local.lsIndex] = av;
                                }
                            } else {
                                ArrayValue av = new ArrayValue();
                                values.add(av);
                                av.s = ArrayValue.S.UNKNOWN;
                                av.indexType = ArrayValue.IndexType.NONE;
                                av.stmt = stmt;
                                this.tmp[local.lsIndex] = av;
                            }
                        }
                    } else if (stmt.getOp1().vt == Value.VT.ARRAY) {
                        this.use(stmt.getOp2());
                        ArrayExpr ae = (ArrayExpr)stmt.getOp1();
                        if (ae.getOp1().vt == Value.VT.LOCAL) {
                            Local local = (Local)ae.getOp1();
                            Value index = ae.getOp2();
                            if (local.lsIndex >= 0) {
                                if (index.vt == Value.VT.CONSTANT) {
                                    ArrayValue parent = this.tmp[local.lsIndex];
                                    ArrayValue av = new ArrayValue();
                                    values.add(av);
                                    av.parent = parent;
                                    av.elements1.put(((Number)((Constant)index).value).intValue(), stmt.getOp2());
                                    av.indexType = ArrayValue.IndexType.CONST;
                                    av.s = ArrayValue.S.INHERIT;
                                    av.stmt = stmt;
                                    this.tmp[local.lsIndex] = av;
                                } else if (index.vt == Value.VT.LOCAL) {
                                    ArrayValue parent = this.tmp[local.lsIndex];
                                    ArrayValue av = new ArrayValue();
                                    values.add(av);
                                    av.parent = parent;
                                    av.elements1.put(index, stmt.getOp2());
                                    av.indexType = ArrayValue.IndexType.LOCAL;
                                    av.s = ArrayValue.S.INHERIT;
                                    av.stmt = stmt;
                                    this.tmp[local.lsIndex] = av;
                                } else {
                                    ArrayValue av = new ArrayValue();
                                    values.add(av);
                                    av.s = ArrayValue.S.UNKNOWN;
                                    av.indexType = ArrayValue.IndexType.NONE;
                                    av.stmt = stmt;
                                    this.tmp[local.lsIndex] = av;
                                }
                            } else {
                                this.use(stmt.getOp1());
                            }
                        } else {
                            this.use(stmt.getOp1());
                        }
                    } else {
                        this.use(stmt.getOp1());
                        this.use(stmt.getOp2());
                    }
                } else if (stmt.st == Stmt.ST.FILL_ARRAY_DATA) {
                    if (stmt.getOp1().vt == Value.VT.LOCAL) {
                        Local local = (Local)stmt.getOp1();
                        if (local.lsIndex >= 0) {
                            Object array = ((Constant)stmt.getOp2()).value;
                            ArrayValue parent = this.tmp[local.lsIndex];
                            ArrayValue av = new ArrayValue();
                            values.add(av);
                            av.parent = parent;
                            int size = Array.getLength(array);
                            av.size = Exprs.nInt(size);
                            for (int i = 0; i < size; ++i) {
                                av.elements1.put(i, Exprs.nConstant(Array.get(array, i)));
                            }
                            av.indexType = ArrayValue.IndexType.CONST;
                            av.s = ArrayValue.S.INHERIT;
                            av.stmt = stmt;
                            this.tmp[local.lsIndex] = av;
                        }
                    } else {
                        this.use(stmt.getOp1());
                    }
                } else {
                    switch (stmt.et) {
                        case E1: {
                            this.use(stmt.getOp());
                            break;
                        }
                        case E2: {
                            this.use(stmt.getOp1());
                            this.use(stmt.getOp2());
                            break;
                        }
                        case En: {
                            throw new RuntimeException();
                        }
                    }
                }
                return this.tmp;
            }

            private void use(Value v) {
                switch (v.et) {
                    case E1: {
                        this.use(v.getOp());
                        break;
                    }
                    case E2: {
                        Value op1 = v.getOp1();
                        Value op2 = v.getOp2();
                        this.use(op1);
                        this.use(op2);
                        if (v.vt != Value.VT.ARRAY || op1.vt != Value.VT.LOCAL || op2.vt != Value.VT.LOCAL && op2.vt != Value.VT.CONSTANT) break;
                        Local local = (Local)op1;
                        if (local.lsIndex <= 0) break;
                        used.add(this.currentStmt);
                        break;
                    }
                    case En: {
                        for (Value op : v.getOps()) {
                            this.use(op);
                        }
                        break;
                    }
                }
            }
        });
        new StmtTraveler(){

            @Override
            public Value travel(Value op) {
                op = super.travel(op);
                return op;
            }
        }.travel(method.stmts);
        return false;
    }

    public static void main(String ... args) {
        IrMethod m = new IrMethod();
        m.isStatic = true;
        m.name = "a";
        m.args = new String[0];
        m.ret = "[Ljava/lang/String;";
        m.owner = "La;";
        Local array = Exprs.nLocal(1);
        m.locals.add(array);
        m.stmts.add(Stmts.nAssign(array, Exprs.nNewArray("Ljava/lang/String;", Exprs.nInt(2))));
        m.stmts.add(Stmts.nAssign(Exprs.nArray(array, Exprs.nInt(1), "Ljava/lang/String;"), Exprs.nString("123")));
        m.stmts.add(Stmts.nAssign(Exprs.nArray(array, Exprs.nInt(0), "Ljava/lang/String;"), Exprs.nString("456")));
        m.stmts.add(Stmts.nReturn(array));
        new ArrayElementTransformer().transform(m);
    }

    private Set<Local> searchForArrayObject(IrMethod method) {
        HashSet<Local> arrays = new HashSet<Local>();
        for (Stmt stmt : method.stmts) {
            Local local;
            if (stmt.st == Stmt.ST.ASSIGN) {
                if (stmt.getOp1().vt == Value.VT.LOCAL) {
                    local = (Local)stmt.getOp1();
                    if (stmt.getOp2().vt != Value.VT.NEW_ARRAY && stmt.getOp2().vt != Value.VT.FILLED_ARRAY) continue;
                    arrays.add(local);
                    continue;
                }
                if (stmt.getOp1().vt != Value.VT.ARRAY) continue;
                ArrayExpr ae = (ArrayExpr)stmt.getOp1();
                if (ae.getOp1().vt != Value.VT.LOCAL) continue;
                Local local2 = (Local)ae.getOp1();
                arrays.add(local2);
                continue;
            }
            if (stmt.st != Stmt.ST.FILL_ARRAY_DATA || stmt.getOp1().vt != Value.VT.LOCAL) continue;
            local = (Local)stmt.getOp1();
            arrays.add(local);
        }
        return arrays;
    }

    static class ArrayValue {
        IndexType indexType = IndexType.NONE;
        S s = S.INHERIT;
        ArrayValue parent;
        Value size;
        Set<ArrayValue> otherParents;
        Map<Object, Value> elements1 = new HashMap<Object, Value>();
        Stmt stmt;

        ArrayValue() {
        }

        static enum IndexType {
            CONST,
            LOCAL,
            NONE;

        }

        static enum S {
            DEFAULT,
            UNKNOWN,
            INHERIT;

        }
    }
}

