/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts.array;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.expr.ArrayExpr;
import com.googlecode.dex2jar.ir.expr.Constant;
import com.googlecode.dex2jar.ir.expr.Exprs;
import com.googlecode.dex2jar.ir.expr.FilledArrayExpr;
import com.googlecode.dex2jar.ir.expr.Local;
import com.googlecode.dex2jar.ir.expr.TypeExpr;
import com.googlecode.dex2jar.ir.expr.Value;
import com.googlecode.dex2jar.ir.stmt.AssignStmt;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.stmt.Stmts;
import com.googlecode.dex2jar.ir.ts.Cfg;
import com.googlecode.dex2jar.ir.ts.StatedTransformer;
import com.googlecode.dex2jar.ir.ts.UniqueQueue;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FillArrayTransformer
extends StatedTransformer {
    public static void main(String ... args) {
        IrMethod m = new IrMethod();
        m.isStatic = true;
        m.name = "a";
        m.args = new String[0];
        m.ret = "[Ljava/lang/String;";
        m.owner = "La;";
        Local array = Exprs.nLocal(1);
        m.locals.add(array);
        m.stmts.add(Stmts.nAssign(array, Exprs.nNewArray("Ljava/lang/String;", Exprs.nInt(2))));
        m.stmts.add(Stmts.nAssign(Exprs.nArray(array, Exprs.nInt(1), "Ljava/lang/String;"), Exprs.nString("123")));
        m.stmts.add(Stmts.nAssign(Exprs.nArray(array, Exprs.nInt(0), "Ljava/lang/String;"), Exprs.nString("456")));
        m.stmts.add(Stmts.nReturn(array));
        new FillArrayTransformer().transform(m);
        System.out.println(m);
    }

    @Override
    public boolean transformReportChanged(IrMethod method) {
        Map<Local, ArrayObject> arraySizes = this.searchForArrayObject(method);
        if (arraySizes.isEmpty()) {
            return false;
        }
        this.makeSureAllElementAreAssigned(arraySizes);
        if (arraySizes.isEmpty()) {
            return false;
        }
        this.makeSureArrayUsedAfterAllElementAssigned(method, arraySizes);
        if (arraySizes.isEmpty()) {
            return false;
        }
        this.replace(method, arraySizes);
        return true;
    }

    private void replace(IrMethod method, Map<Local, ArrayObject> arraySizes) {
        final ArrayList filledArrayExprs = new ArrayList();
        for (Map.Entry<Local, ArrayObject> e : arraySizes.entrySet()) {
            final Local local0 = e.getKey();
            final ArrayObject ao = e.getValue();
            final Value[] t = new Value[ao.size];
            for (Stmt p : ao.putItem) {
                if (p.st == Stmt.ST.FILL_ARRAY_DATA) {
                    Local local = (Local)p.getOp1();
                    if (local != local0) continue;
                    Object vs = ((Constant)p.getOp2()).value;
                    int endPos = Array.getLength(vs);
                    for (int j = 0; j < endPos; ++j) {
                        t[j] = Exprs.nConstant(Array.get(vs, j));
                    }
                    continue;
                }
                ArrayExpr ae = (ArrayExpr)p.getOp1();
                Local local = (Local)ae.getOp1();
                if (local != local0) continue;
                int idx = ((Number)((Constant)ae.getOp2()).value).intValue();
                Value op2 = p.getOp2();
                if (op2.vt != Value.VT.LOCAL && op2.vt != Value.VT.CONSTANT) {
                    Local n = new Local(-1);
                    method.locals.add(n);
                    method.stmts.insertBefore(p, Stmts.nAssign(n, op2));
                    op2 = n;
                }
                t[idx] = op2;
            }
            method.locals.remove(local0);
            method.stmts.remove(ao.init);
            for (Stmt p : ao.putItem) {
                method.stmts.remove(p);
            }
            Cfg.TravelCallBack tcb = new Cfg.TravelCallBack(){
                final /* synthetic */ FillArrayTransformer this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Value onAssign(Local v, AssignStmt as) {
                    return v;
                }

                @Override
                public Value onUse(Local v) {
                    if (local0 == v) {
                        FilledArrayExpr fae = Exprs.nFilledArray(ao.type, t);
                        filledArrayExprs.add(fae);
                        return fae;
                    }
                    return v;
                }
            };
            if (ao.used.size() == 1) {
                Stmt stmt = ao.used.get(0);
                if (method.stmts.contains(stmt)) {
                    Cfg.travelMod(stmt, tcb, false);
                    continue;
                }
                int size = filledArrayExprs.size();
                for (int i = 0; i < size; ++i) {
                    Cfg.travelMod((Value)filledArrayExprs.get(i), tcb);
                }
                continue;
            }
            if (ao.used.isEmpty()) continue;
            throw new RuntimeException("array is used multiple times");
        }
    }

    private void makeSureArrayUsedAfterAllElementAssigned(IrMethod method, Map<Local, ArrayObject> arraySizes) {
        for (Local local : method.locals) {
            local.lsIndex = -1;
        }
        int max = 50;
        if (arraySizes.size() < 50) {
            this.makeSureArrayUsedAfterAllElementAssigned0(method, arraySizes);
        } else {
            HashMap<Local, ArrayObject> keptInAll = new HashMap<Local, ArrayObject>();
            HashMap<Local, ArrayObject> keptInPart = new HashMap<Local, ArrayObject>();
            ArrayList<Local> arrays = new ArrayList<Local>(50);
            Iterator<Map.Entry<Local, ArrayObject>> it = arraySizes.entrySet().iterator();
            while (it.hasNext()) {
                for (int i = 0; i < 50 && it.hasNext(); ++i) {
                    Map.Entry<Local, ArrayObject> e = it.next();
                    keptInPart.put(e.getKey(), e.getValue());
                    it.remove();
                    arrays.add(e.getKey());
                }
                this.makeSureArrayUsedAfterAllElementAssigned0(method, keptInPart);
                for (Local local : arrays) {
                    local.lsIndex = -1;
                }
                arrays.clear();
                keptInAll.putAll(keptInPart);
                keptInPart.clear();
            }
            arraySizes.putAll(keptInAll);
        }
        Cfg.reIndexLocal(method);
    }

    private void makeSureArrayUsedAfterAllElementAssigned0(IrMethod method, final Map<Local, ArrayObject> arraySizes) {
        int i = 0;
        for (Local local : arraySizes.keySet()) {
            local.lsIndex = i++;
        }
        final int size = i;
        final ArrayList<ArrayObjectValue> values = new ArrayList<ArrayObjectValue>();
        Cfg.dfs(method.stmts, new Cfg.FrameVisitor<ArrayObjectValue[]>(){
            ArrayObjectValue[] tmp = this.initFirstFrame(null);
            Stmt currentStmt;
            final /* synthetic */ FillArrayTransformer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public ArrayObjectValue[] merge(ArrayObjectValue[] srcFrame, ArrayObjectValue[] distFrame, Stmt src, Stmt dist) {
                if (distFrame == null) {
                    distFrame = new ArrayObjectValue[size];
                    for (int i = 0; i < size; ++i) {
                        ArrayObjectValue arc = srcFrame[i];
                        if (arc == null) continue;
                        ArrayObjectValue aov = new ArrayObjectValue(arc.local);
                        values.add(aov);
                        aov.array = arc.array;
                        aov.parent = arc;
                        aov.pos = (BitSet)arc.pos.clone();
                        distFrame[i] = aov;
                    }
                } else {
                    for (int i = 0; i < size; ++i) {
                        ArrayObjectValue arc = srcFrame[i];
                        ArrayObjectValue aov = distFrame[i];
                        if (arc == null || aov == null) continue;
                        if (aov.otherParent == null) {
                            aov.otherParent = new HashSet<ArrayObjectValue>();
                        }
                        aov.otherParent.add(arc);
                    }
                }
                return distFrame;
            }

            @Override
            public ArrayObjectValue[] initFirstFrame(Stmt first) {
                return new ArrayObjectValue[size];
            }

            @Override
            public ArrayObjectValue[] exec(ArrayObjectValue[] frame, Stmt stmt) {
                this.currentStmt = stmt;
                System.arraycopy(frame, 0, this.tmp, 0, size);
                if (stmt.st == Stmt.ST.FILL_ARRAY_DATA) {
                    if (stmt.getOp1().vt == Value.VT.LOCAL) {
                        Local local = (Local)stmt.getOp1();
                        if (local.lsIndex >= 0) {
                            ArrayObjectValue av = this.tmp[local.lsIndex];
                            Constant cst = (Constant)stmt.getOp2();
                            int endPos = Array.getLength(cst.value);
                            av.pos.set(0, endPos);
                        }
                    } else {
                        this.use(stmt.getOp1());
                    }
                } else if (stmt.st == Stmt.ST.ASSIGN && stmt.getOp1().vt == Value.VT.ARRAY) {
                    this.use(stmt.getOp2());
                    ArrayExpr ae = (ArrayExpr)stmt.getOp1();
                    if (ae.getOp1().vt == Value.VT.LOCAL) {
                        Local local = (Local)ae.getOp1();
                        if (local.lsIndex >= 0) {
                            int index = ((Number)((Constant)ae.getOp2()).value).intValue();
                            ArrayObjectValue av = this.tmp[local.lsIndex];
                            av.pos.set(index);
                        } else {
                            this.use(ae);
                        }
                    } else {
                        this.use(ae);
                    }
                } else if (stmt.st == Stmt.ST.ASSIGN && stmt.getOp1().vt == Value.VT.LOCAL) {
                    Local local = (Local)stmt.getOp1();
                    this.use(stmt.getOp2());
                    if (local.lsIndex >= 0) {
                        ArrayObjectValue aov = new ArrayObjectValue(local);
                        aov.array = (ArrayObject)arraySizes.get(local);
                        aov.pos = new BitSet();
                        values.add(aov);
                        this.tmp[local.lsIndex] = aov;
                    }
                } else {
                    switch (stmt.et) {
                        case E1: {
                            this.use(stmt.getOp());
                            break;
                        }
                        case E2: {
                            this.use(stmt.getOp1());
                            this.use(stmt.getOp2());
                            break;
                        }
                        case En: {
                            throw new RuntimeException();
                        }
                    }
                }
                return this.tmp;
            }

            private void use(Value v) {
                switch (v.et) {
                    case E0: {
                        if (v.vt != Value.VT.LOCAL) break;
                        Local local = (Local)v;
                        if (local.lsIndex < 0) break;
                        ArrayObjectValue aov = this.tmp[local.lsIndex];
                        aov.array.used.add(this.currentStmt);
                        aov.used = true;
                        break;
                    }
                    case E1: {
                        this.use(v.getOp());
                        break;
                    }
                    case E2: {
                        this.use(v.getOp1());
                        this.use(v.getOp2());
                        break;
                    }
                    case En: {
                        for (Value op : v.getOps()) {
                            this.use(op);
                        }
                        break;
                    }
                }
            }
        });
        Set<ArrayObjectValue> used = this.markUsed(values);
        block1: for (ArrayObjectValue avo : used) {
            if (avo.array.used.size() > 1) {
                arraySizes.remove(avo.local);
                continue;
            }
            if (avo.parent == null || avo.otherParent == null) continue;
            BitSet p = avo.parent.pos;
            for (ArrayObjectValue ps : avo.otherParent) {
                if (p.equals(ps.pos)) continue;
                arraySizes.remove(avo.local);
                continue block1;
            }
        }
        Iterator<Map.Entry<Local, ArrayObject>> it = arraySizes.entrySet().iterator();
        block3: while (it.hasNext()) {
            Map.Entry<Local, ArrayObject> e = it.next();
            Local local = e.getKey();
            ArrayObject arrayObject = e.getValue();
            for (Stmt use : arrayObject.used) {
                ArrayObjectValue[] frame = (ArrayObjectValue[])use.frame;
                ArrayObjectValue aov = frame[local.lsIndex];
                BitSet pos = aov.pos;
                if (pos.nextClearBit(0) >= arrayObject.size && pos.nextSetBit(arrayObject.size) < 0) continue;
                it.remove();
                continue block3;
            }
        }
        for (Stmt stmt : method.stmts) {
            stmt.frame = null;
        }
    }

    protected Set<ArrayObjectValue> markUsed(Collection<ArrayObjectValue> values) {
        HashSet<ArrayObjectValue> used = new HashSet<ArrayObjectValue>(values.size() / 2);
        UniqueQueue q = new UniqueQueue();
        q.addAll(values);
        values.clear();
        while (!q.isEmpty()) {
            ArrayObjectValue v = (ArrayObjectValue)q.poll();
            if (!v.used || used.contains(v)) continue;
            used.add(v);
            ArrayObjectValue p = v.parent;
            if (p != null && !p.used) {
                p.used = true;
                q.add(p);
            }
            if (v.otherParent == null) continue;
            for (ArrayObjectValue p2 : v.otherParent) {
                if (p2.used) continue;
                p2.used = true;
                q.add(p2);
            }
        }
        return used;
    }

    private void makeSureAllElementAreAssigned(Map<Local, ArrayObject> arraySizes) {
        BitSet pos = new BitSet();
        Iterator<Map.Entry<Local, ArrayObject>> it = arraySizes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Local, ArrayObject> e = it.next();
            ArrayObject arrayObject = e.getValue();
            boolean needRemove = false;
            for (Stmt p : arrayObject.putItem) {
                if (p.st == Stmt.ST.FILL_ARRAY_DATA) {
                    int endPos = Array.getLength(((Constant)p.getOp2()).value);
                    int next = pos.nextSetBit(0);
                    if (next < 0 || next >= endPos) {
                        pos.set(0, endPos);
                        continue;
                    }
                    needRemove = true;
                    break;
                }
                ArrayExpr ae = (ArrayExpr)p.getOp1();
                int idx = ((Number)((Constant)ae.getOp2()).value).intValue();
                if (!pos.get(idx)) {
                    pos.set(idx);
                    continue;
                }
                needRemove = true;
                break;
            }
            if (needRemove || pos.nextClearBit(0) < arrayObject.size || pos.nextSetBit(arrayObject.size) >= 0) {
                it.remove();
            }
            pos.clear();
        }
    }

    private Map<Local, ArrayObject> searchForArrayObject(IrMethod method) {
        HashMap<Local, ArrayObject> arraySizes = new HashMap<Local, ArrayObject>();
        if (method.locals.isEmpty()) {
            return arraySizes;
        }
        Cfg.createCFG(method);
        Cfg.dfsVisit(method, p -> {
            Local local;
            ArrayObject arrayObject;
            if (p.st == Stmt.ST.ASSIGN) {
                if (p.getOp2().vt == Value.VT.NEW_ARRAY && p.getOp1().vt == Value.VT.LOCAL) {
                    int size;
                    TypeExpr ae = (TypeExpr)p.getOp2();
                    if (ae.getOp().vt == Value.VT.CONSTANT && (size = ((Number)((Constant)ae.getOp()).value).intValue()) >= 0) {
                        arraySizes.put((Local)p.getOp1(), new ArrayObject(size, ae.type, (AssignStmt)p));
                    }
                } else if (p.getOp1().vt == Value.VT.ARRAY) {
                    Local local2;
                    ArrayObject arrayObject2;
                    ArrayExpr ae = (ArrayExpr)p.getOp1();
                    if (ae.getOp1().vt == Value.VT.LOCAL && (arrayObject2 = (ArrayObject)arraySizes.get(local2 = (Local)ae.getOp1())) != null) {
                        if (ae.getOp2().vt == Value.VT.CONSTANT) {
                            arrayObject2.putItem.add(p);
                        } else {
                            arraySizes.remove(local2);
                        }
                    }
                }
            } else if (p.st == Stmt.ST.FILL_ARRAY_DATA && p.getOp1().vt == Value.VT.LOCAL && (arrayObject = (ArrayObject)arraySizes.get(local = (Local)p.getOp1())) != null) {
                arrayObject.putItem.add(p);
            }
        });
        if (!arraySizes.isEmpty()) {
            HashSet<Local> set = new HashSet<Local>();
            if (method.phiLabels != null) {
                for (LabelStmt labelStmt : method.phiLabels) {
                    if (labelStmt.phis == null) continue;
                    for (AssignStmt as : labelStmt.phis) {
                        set.add((Local)as.getOp1());
                        for (Value v : as.getOp2().getOps()) {
                            set.add((Local)v);
                        }
                    }
                }
            }
            if (!set.isEmpty()) {
                for (Local local : set) {
                    arraySizes.remove(local);
                }
            }
        }
        return arraySizes;
    }

    private static final class ArrayObject {
        int size;
        String type;
        AssignStmt init;
        List<Stmt> putItem = new ArrayList<Stmt>();
        List<Stmt> used = new ArrayList<Stmt>();

        private ArrayObject(int size, String type, AssignStmt init) {
            this.size = size;
            this.type = type;
            this.init = init;
        }
    }

    static class ArrayObjectValue {
        BitSet pos;
        Local local;
        ArrayObject array;
        ArrayObjectValue parent;
        Set<ArrayObjectValue> otherParent;
        boolean used;

        ArrayObjectValue(Local local) {
            this.local = local;
        }
    }
}

