/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.jasmin;

import com.googlecode.d2j.jasmin.JasminDumper;
import com.googlecode.dex2jar.tools.BaseCmd;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

@BaseCmd.Syntax(cmd="d2j-jar2jasmin", syntax="[options] <jar>", desc="Disassemble .class in jar file to jasmin file", onlineHelp="https://sourceforge.net/p/dex2jar/wiki/Jasmin")
public class Jar2JasminCmd
extends BaseCmd {
    @BaseCmd.Opt(opt="d", longOpt="debug", hasArg=false, description="disassemble debug info")
    private boolean debugInfo = false;
    @BaseCmd.Opt(opt="f", longOpt="force", hasArg=false, description="force overwrite")
    private boolean forceOverwrite = false;
    @BaseCmd.Opt(opt="o", longOpt="output", description="output dir of .j files, default is $current_dir/[jar-name]-jar2jasmin/", argName="out-dir")
    private Path output;
    @BaseCmd.Opt(opt="e", longOpt="encoding", description="encoding for .j files, default is UTF-8", argName="enc")
    private String encoding = "UTF-8";

    public static void main(String ... args) {
        new Jar2JasminCmd().doMain(args);
    }

    protected void doCommandLine() throws Exception {
        if (this.remainingArgs.length != 1) {
            this.usage();
            return;
        }
        Path jar = new File(this.remainingArgs[0]).toPath().toAbsolutePath();
        if (!Files.exists(jar, new LinkOption[0])) {
            System.err.println(jar + " doesn't exist");
            this.usage();
            return;
        }
        if (this.output == null) {
            this.output = new File(Jar2JasminCmd.getBaseName((Path)jar) + "-jar2jasmin/").toPath();
        }
        if (Files.exists(this.output, new LinkOption[0]) && !this.forceOverwrite) {
            System.err.println(this.output + " exists, use --force to overwrite");
            this.usage();
            return;
        }
        System.out.println("disassemble " + jar + " -> " + this.output);
        if (!this.output.toString().endsWith(".jar") && !this.output.toString().endsWith(".apk")) {
            this.disassemble0(jar, this.output);
        } else {
            try (FileSystem fs = Jar2JasminCmd.createZip((Path)this.output);){
                this.disassemble0(jar, fs.getPath("/", new String[0]));
            }
        }
    }

    private void disassemble0(Path in, Path output) throws IOException {
        if (Files.isDirectory(in, new LinkOption[0])) {
            this.travelFileTree(in, output);
        } else if (in.toString().endsWith(".class")) {
            this.disassemble1(in, output);
        } else {
            try (FileSystem fs = Jar2JasminCmd.openZip((Path)in);){
                this.travelFileTree(fs.getPath("/", new String[0]), output);
            }
        }
    }

    private void travelFileTree(Path in, final Path output) throws IOException {
        Files.walkFileTree(in, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){
            final /* synthetic */ Jar2JasminCmd this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.getFileName().toString().endsWith(".class")) {
                    this.this$0.disassemble1(file, output);
                }
                return super.visitFile(file, attrs);
            }
        });
    }

    private void disassemble1(Path file, Path output) throws IOException {
        ClassReader r = new ClassReader(Files.readAllBytes(file));
        Path jFile = output.resolve(r.getClassName().replace('.', '/') + ".j");
        Jar2JasminCmd.createParentDirectories((Path)jFile);
        try (BufferedWriter out = Files.newBufferedWriter(jFile, Charset.forName(this.encoding), new OpenOption[0]);){
            PrintWriter pw = new PrintWriter(out);
            ClassNode node = new ClassNode();
            r.accept((ClassVisitor)node, (this.debugInfo ? 0 : 2) | 8 | 4);
            new JasminDumper(pw).dump(node);
            pw.flush();
        }
    }
}

