/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.converter;

import com.googlecode.d2j.CallSite;
import com.googlecode.d2j.DexLabel;
import com.googlecode.d2j.DexType;
import com.googlecode.d2j.Field;
import com.googlecode.d2j.Method;
import com.googlecode.d2j.MethodHandle;
import com.googlecode.d2j.Proto;
import com.googlecode.d2j.node.DexCodeNode;
import com.googlecode.d2j.node.DexDebugNode;
import com.googlecode.d2j.node.TryCatchNode;
import com.googlecode.d2j.node.analysis.DvmFrame;
import com.googlecode.d2j.node.analysis.DvmInterpreter;
import com.googlecode.d2j.node.insn.BaseSwitchStmtNode;
import com.googlecode.d2j.node.insn.ConstStmtNode;
import com.googlecode.d2j.node.insn.DexLabelStmtNode;
import com.googlecode.d2j.node.insn.DexStmtNode;
import com.googlecode.d2j.node.insn.FieldStmtNode;
import com.googlecode.d2j.node.insn.FillArrayDataStmtNode;
import com.googlecode.d2j.node.insn.FilledNewArrayStmtNode;
import com.googlecode.d2j.node.insn.JumpStmtNode;
import com.googlecode.d2j.node.insn.MethodCustomStmtNode;
import com.googlecode.d2j.node.insn.MethodPolymorphicStmtNode;
import com.googlecode.d2j.node.insn.MethodStmtNode;
import com.googlecode.d2j.node.insn.PackedSwitchStmtNode;
import com.googlecode.d2j.node.insn.SparseSwitchStmtNode;
import com.googlecode.d2j.node.insn.Stmt2R1NNode;
import com.googlecode.d2j.node.insn.TypeStmtNode;
import com.googlecode.d2j.reader.Op;
import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.Trap;
import com.googlecode.dex2jar.ir.TypeClass;
import com.googlecode.dex2jar.ir.expr.Exprs;
import com.googlecode.dex2jar.ir.expr.InvokeCustomExpr;
import com.googlecode.dex2jar.ir.expr.InvokeExpr;
import com.googlecode.dex2jar.ir.expr.InvokePolymorphicExpr;
import com.googlecode.dex2jar.ir.expr.Local;
import com.googlecode.dex2jar.ir.expr.Value;
import com.googlecode.dex2jar.ir.stmt.AssignStmt;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.stmt.StmtList;
import com.googlecode.dex2jar.ir.stmt.Stmts;
import com.googlecode.dex2jar.ir.ts.UniqueQueue;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;

public class Dex2IRConverter {
    Map<DexLabel, DexLabelStmtNode> labelMap = new HashMap<DexLabel, DexLabelStmtNode>();
    List<DexStmtNode> insnList;
    int[] parentCount;
    IrMethod target;
    DexCodeNode dexCodeNode;
    List<Stmt> preEmit = new ArrayList<Stmt>();
    List<Stmt> currentEmit;
    Map<DexLabel, LabelStmt> map = new HashMap<DexLabel, LabelStmt>();
    private Dex2IrFrame[] frames;
    private ArrayList<Stmt>[] emitStmts;
    boolean initAllToZero = true;

    static int sizeofType(String s) {
        char t = s.charAt(0);
        if (t == 'J' || t == 'D') {
            return 2;
        }
        return 1;
    }

    static int methodArgCount(String[] args) {
        int i = 0;
        for (String s : args) {
            i += Dex2IRConverter.sizeofType(s);
        }
        return i;
    }

    public IrMethod convert(boolean isStatic, Method method, DexCodeNode dexCodeNode) {
        this.dexCodeNode = dexCodeNode;
        IrMethod irMethod = new IrMethod();
        irMethod.args = method.getParameterTypes();
        irMethod.ret = method.getReturnType();
        irMethod.owner = method.getOwner();
        irMethod.name = method.getName();
        irMethod.isStatic = isStatic;
        this.target = irMethod;
        this.insnList = dexCodeNode.stmts;
        for (int i = 0; i < this.insnList.size(); ++i) {
            DexStmtNode stmtNode = this.insnList.get(i);
            stmtNode.index = i;
            if (!(stmtNode instanceof DexLabelStmtNode)) continue;
            DexLabelStmtNode dexLabelStmtNode = (DexLabelStmtNode)stmtNode;
            this.labelMap.put(dexLabelStmtNode.label, dexLabelStmtNode);
        }
        this.fixExceptionHandlers();
        BitSet[] exBranch = new BitSet[this.insnList.size()];
        this.parentCount = new int[this.insnList.size()];
        this.initParentCount(this.parentCount);
        BitSet handlers = new BitSet(this.insnList.size());
        this.initExceptionHandlers(dexCodeNode, exBranch, handlers);
        DvmInterpreter<DvmValue> interpreter = this.buildInterpreter();
        this.frames = new Dex2IrFrame[this.insnList.size()];
        this.emitStmts = new ArrayList[this.insnList.size()];
        BitSet access = new BitSet(this.insnList.size());
        this.dfs(exBranch, handlers, access, interpreter);
        StmtList stmts = this.target.stmts;
        stmts.addAll(this.preEmit);
        for (int i = 0; i < this.insnList.size(); ++i) {
            DexStmtNode p = this.insnList.get(i);
            if (access.get(i)) {
                ArrayList<Stmt> es = this.emitStmts[i];
                if (es == null) continue;
                stmts.addAll(es);
                continue;
            }
            if (!(p instanceof DexLabelStmtNode)) continue;
            stmts.add((Stmt)this.getLabel(((DexLabelStmtNode)p).label));
        }
        this.emitStmts = null;
        UniqueQueue queue = new UniqueQueue();
        for (int i1 = 0; i1 < this.frames.length; ++i1) {
            Dex2IrFrame frame = this.frames[i1];
            if (this.parentCount[i1] <= 1 || frame == null || !access.get(i1)) continue;
            for (int j = 0; j < frame.getTotalRegisters(); ++j) {
                DvmValue v = (DvmValue)frame.getReg(j);
                this.addToQueue((Queue<DvmValue>)queue, v);
            }
        }
        while (!queue.isEmpty()) {
            DvmValue v = (DvmValue)queue.poll();
            this.getLocal(v);
            if (v.parent != null && v.parent.local == null) {
                queue.add(v.parent);
            }
            if (v.otherParent == null) continue;
            for (DvmValue v2 : v.otherParent) {
                if (v2.local != null) continue;
                queue.add(v2);
            }
        }
        HashSet<Value> phiValues = new HashSet<Value>();
        ArrayList<LabelStmt> phiLabels = new ArrayList<LabelStmt>();
        for (int i = 0; i < this.frames.length; ++i) {
            Dex2IrFrame frame = this.frames[i];
            if (this.parentCount[i] <= 1 || frame == null || !access.get(i)) continue;
            DexStmtNode p = this.insnList.get(i);
            LabelStmt labelStmt = this.getLabel(((DexLabelStmtNode)p).label);
            ArrayList<AssignStmt> phis = new ArrayList<AssignStmt>();
            for (int j = 0; j < frame.getTotalRegisters(); ++j) {
                DvmValue v = (DvmValue)frame.getReg(j);
                this.addPhi(v, phiValues, phis);
            }
            labelStmt.phis = phis;
            phiLabels.add(labelStmt);
        }
        if (!phiLabels.isEmpty()) {
            this.target.phiLabels = phiLabels;
        }
        this.supplementLineNumber(dexCodeNode);
        return this.target;
    }

    private void supplementLineNumber(DexCodeNode dexCodeNode) {
        if (dexCodeNode == null || dexCodeNode.debugNode == null || dexCodeNode.debugNode.debugNodes == null) {
            return;
        }
        HashMap<DexLabel, Integer> lineNumber = new HashMap<DexLabel, Integer>();
        for (DexDebugNode.DexDebugOpNode dexDebugOpNode : dexCodeNode.debugNode.debugNodes) {
            if (!(dexDebugOpNode instanceof DexDebugNode.DexDebugOpNode.LineNumber)) continue;
            lineNumber.put(dexDebugOpNode.label, ((DexDebugNode.DexDebugOpNode.LineNumber)dexDebugOpNode).line);
        }
        for (Map.Entry entry : this.map.entrySet()) {
            Integer line = (Integer)lineNumber.get(entry.getKey());
            if (line == null) continue;
            ((LabelStmt)entry.getValue()).lineNumber = line;
        }
    }

    private void fixExceptionHandlers() {
        if (this.dexCodeNode.tryStmts == null) {
            return;
        }
        LinkedList<Integer> q = new LinkedList<Integer>();
        TreeSet<Integer> handlers = new TreeSet<Integer>();
        for (TryCatchNode tcb : this.dexCodeNode.tryStmts) {
            for (DexLabel h : tcb.handler) {
                int index = this.indexOf(h);
                q.add(index + 1);
                handlers.add(index);
            }
        }
        q.add(0);
        HashMap<Integer, DexLabel> needChange = new HashMap<Integer, DexLabel>();
        BitSet access = new BitSet(this.insnList.size());
        while (!q.isEmpty()) {
            Integer key = (Integer)q.poll();
            int index = key;
            if (access.get(index)) continue;
            access.set(index);
            if (handlers.contains(key)) {
                needChange.put(key, null);
            }
            DexStmtNode node = this.insnList.get(key);
            if (node.op == null) {
                q.add(index + 1);
                continue;
            }
            Op op = node.op;
            if (op.canContinue()) {
                q.add(index + 1);
            }
            if (op.canBranch()) {
                DexLabel[] jump = (DexLabel[])node;
                q.add(this.indexOf(jump.label));
            }
            if (!op.canSwitch()) continue;
            for (DexLabel dexLabel : ((BaseSwitchStmtNode)node).labels) {
                q.add(this.indexOf(dexLabel));
            }
        }
        if (!needChange.isEmpty()) {
            for (TryCatchNode tcb : this.dexCodeNode.tryStmts) {
                DexLabel[] handler = tcb.handler;
                for (int i = 0; i < handler.length; ++i) {
                    DexLabel h = handler[i];
                    int index = this.indexOf(h);
                    if (!needChange.containsKey(index)) continue;
                    DexLabel n = (DexLabel)needChange.get(index);
                    if (n == null) {
                        n = new DexLabel();
                        needChange.put(index, n);
                        DexLabelStmtNode dexStmtNode = new DexLabelStmtNode(n);
                        dexStmtNode.index = this.insnList.size();
                        this.insnList.add((DexStmtNode)dexStmtNode);
                        this.labelMap.put(n, dexStmtNode);
                        JumpStmtNode jumpStmtNode = new JumpStmtNode(Op.GOTO, 0, 0, h);
                        jumpStmtNode.index = this.insnList.size();
                        this.insnList.add((DexStmtNode)jumpStmtNode);
                    }
                    handler[i] = n;
                }
            }
        }
    }

    private void initExceptionHandlers(DexCodeNode dexCodeNode, BitSet[] exBranch, BitSet handlers) {
        if (dexCodeNode.tryStmts != null) {
            for (TryCatchNode tcb : dexCodeNode.tryStmts) {
                for (DexLabel h : tcb.handler) {
                    handlers.set(this.indexOf(h));
                }
                boolean hasEx = false;
                int endIndex = this.indexOf(tcb.end);
                for (int p = this.indexOf(tcb.start) + 1; p < endIndex; ++p) {
                    DexStmtNode stmt = this.insnList.get(p);
                    if (stmt.op == null || !stmt.op.canThrow()) continue;
                    hasEx = true;
                    BitSet x = exBranch[p];
                    if (x == null) {
                        exBranch[p] = new BitSet(this.insnList.size());
                        x = exBranch[p];
                    }
                    for (DexLabel h : tcb.handler) {
                        int hIndex = this.indexOf(h);
                        x.set(hIndex);
                        int n = hIndex;
                        this.parentCount[n] = this.parentCount[n] + 1;
                    }
                }
                if (!hasEx) continue;
                this.target.traps.add(new Trap(this.getLabel(tcb.start), this.getLabel(tcb.end), this.getLabels(tcb.handler), tcb.type));
            }
        }
    }

    private void addPhi(DvmValue v, Set<Value> phiValues, List<AssignStmt> phis) {
        if (v != null && v.local != null) {
            if (v.parent != null) {
                phiValues.add((Value)this.getLocal(v.parent));
            }
            if (v.otherParent != null) {
                for (DvmValue v2 : v.otherParent) {
                    phiValues.add((Value)this.getLocal(v2));
                }
            }
            if (!phiValues.isEmpty()) {
                phis.add(Stmts.nAssign((Value)v.local, (Value)Exprs.nPhi((Value[])phiValues.toArray(new Value[0]))));
                phiValues.clear();
            }
        }
    }

    Local getLocal(DvmValue value) {
        Local local = value.local;
        if (local == null) {
            local = value.local = this.newLocal();
        }
        return local;
    }

    private void addToQueue(Queue<DvmValue> queue, DvmValue v) {
        if (v != null && v.local != null) {
            if (v.parent != null && v.parent.local == null) {
                queue.add(v.parent);
            }
            if (v.otherParent != null) {
                for (DvmValue v2 : v.otherParent) {
                    if (v2.local != null) continue;
                    queue.add(v2);
                }
            }
        }
    }

    private void setCurrentEmit(int index) {
        this.currentEmit = this.emitStmts[index];
        if (this.currentEmit == null) {
            this.emitStmts[index] = new ArrayList(1);
            this.currentEmit = this.emitStmts[index];
        }
    }

    private void dfs(BitSet[] exBranch, BitSet handlers, BitSet access, DvmInterpreter<DvmValue> interpreter) {
        this.currentEmit = this.preEmit;
        Dex2IrFrame first = this.initFirstFrame(this.dexCodeNode, this.target);
        if (this.parentCount[0] > 1) {
            this.merge(first, 0);
        } else {
            this.frames[0] = first;
        }
        Stack<DexStmtNode> stack = new Stack<DexStmtNode>();
        stack.push(this.insnList.get(0));
        Dex2IrFrame tmp = new Dex2IrFrame(this.dexCodeNode.totalRegister);
        while (!stack.isEmpty()) {
            BitSet ex;
            DexStmtNode p = (DexStmtNode)stack.pop();
            int index = p.index;
            if (access.get(index)) continue;
            access.set(index);
            Dex2IrFrame frame = this.frames[index];
            this.setCurrentEmit(index);
            if (p instanceof DexLabelStmtNode) {
                this.emit((Stmt)this.getLabel(((DexLabelStmtNode)p).label));
                if (handlers.get(index)) {
                    ex = this.newLocal();
                    this.emit((Stmt)Stmts.nIdentity((Value)ex, (Value)Exprs.nExceptionRef((String)"Ljava/lang/Throwable;")));
                    frame.setTmp(new DvmValue((Local)ex));
                }
            }
            if ((ex = exBranch[index]) != null) {
                int i = ex.nextSetBit(0);
                while (i >= 0) {
                    this.merge(frame, i);
                    stack.push(this.insnList.get(i));
                    i = ex.nextSetBit(i + 1);
                }
            }
            tmp.init(frame);
            try {
                if (p.op != null) {
                    switch (p.op) {
                        case RETURN_VOID: {
                            this.emit((Stmt)Stmts.nReturnVoid());
                            break;
                        }
                        case GOTO: 
                        case GOTO_16: 
                        case GOTO_32: {
                            this.emit((Stmt)Stmts.nGoto((LabelStmt)this.getLabel(((JumpStmtNode)p).label)));
                            break;
                        }
                        case NOP: {
                            this.emit((Stmt)Stmts.nNop());
                            break;
                        }
                        case BAD_OP: {
                            this.emit((Stmt)Stmts.nThrow((Value)Exprs.nInvokeNew((Value[])new Value[]{Exprs.nString((String)"bad dex opcode")}, (String[])new String[]{"Ljava/lang/String;"}, (String)"Ljava/lang/VerifyError;")));
                            break;
                        }
                        default: {
                            tmp.execute(p, interpreter);
                        }
                    }
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("Fail on Op " + p.op + " index " + index, exception);
            }
            if (p.op != null) {
                Op op = p.op;
                if (op.canBranch()) {
                    JumpStmtNode jump = (JumpStmtNode)p;
                    int targetIndex = this.indexOf(jump.label);
                    stack.push(this.insnList.get(targetIndex));
                    this.merge(tmp, targetIndex);
                }
                if (op.canSwitch()) {
                    BaseSwitchStmtNode switchStmtNode = (BaseSwitchStmtNode)p;
                    for (DexLabel label : switchStmtNode.labels) {
                        int targetIndex = this.indexOf(label);
                        stack.push(this.insnList.get(targetIndex));
                        this.merge(tmp, targetIndex);
                    }
                }
                if (op.canContinue()) {
                    stack.push(this.insnList.get(index + 1));
                    this.merge(tmp, index + 1);
                }
            } else {
                stack.push(this.insnList.get(index + 1));
                this.merge(tmp, index + 1);
            }
            if (this.parentCount[index] > 1) continue;
            this.frames[index] = null;
        }
    }

    private void relate(DvmValue parent, DvmValue child) {
        if (child.parent == null) {
            child.parent = parent;
        } else if (child.parent != parent) {
            if (child.otherParent == null) {
                child.otherParent = new HashSet<DvmValue>(5);
            }
            child.otherParent.add(parent);
        }
    }

    void merge(Dex2IrFrame src, int dst) {
        Dex2IrFrame distFrame = this.frames[dst];
        if (distFrame == null) {
            this.frames[dst] = new Dex2IrFrame(this.dexCodeNode.totalRegister);
            distFrame = this.frames[dst];
        }
        if (this.parentCount[dst] > 1) {
            for (int i = 0; i < src.getTotalRegisters(); ++i) {
                DvmValue p = (DvmValue)src.getReg(i);
                DvmValue q = (DvmValue)distFrame.getReg(i);
                if (p == null) continue;
                if (q == null) {
                    q = new DvmValue();
                    distFrame.setReg(i, q);
                }
                this.relate(p, q);
            }
        } else {
            distFrame.init(src);
        }
    }

    private Local newLocal() {
        Local thiz = Exprs.nLocal((int)this.target.locals.size());
        this.target.locals.add(thiz);
        return thiz;
    }

    void emit(Stmt stmt) {
        this.currentEmit.add(stmt);
    }

    private Dex2IrFrame initFirstFrame(DexCodeNode methodNode, IrMethod target) {
        Local p;
        int i;
        Dex2IrFrame first = new Dex2IrFrame(methodNode.totalRegister);
        int x = methodNode.totalRegister - Dex2IRConverter.methodArgCount(target.args);
        if (!target.isStatic) {
            Local thiz = this.newLocal();
            this.emit((Stmt)Stmts.nIdentity((Value)thiz, (Value)Exprs.nThisRef((String)target.owner)));
            first.setReg(x - 1, new DvmValue(thiz));
        }
        for (i = 0; i < target.args.length; ++i) {
            p = this.newLocal();
            this.emit((Stmt)Stmts.nIdentity((Value)p, (Value)Exprs.nParameterRef((String)target.args[i], (int)i)));
            first.setReg(x, new DvmValue(p));
            x += Dex2IRConverter.sizeofType(target.args[i]);
        }
        if (this.initAllToZero) {
            for (i = 0; i < first.getTotalRegisters(); ++i) {
                if (first.getReg(i) != null) continue;
                p = this.newLocal();
                this.emit((Stmt)Stmts.nAssign((Value)p, (Value)Exprs.nInt((int)0)));
                first.setReg(i, new DvmValue(p));
            }
        }
        return first;
    }

    private DvmInterpreter<DvmValue> buildInterpreter() {
        return new DvmInterpreter<DvmValue>(){

            DvmValue b(Value value) {
                Local local = Dex2IRConverter.this.newLocal();
                Dex2IRConverter.this.emit((Stmt)Stmts.nAssign((Value)local, (Value)value));
                return new DvmValue(local);
            }

            public DvmValue newOperation(DexStmtNode insn) {
                switch (insn.op) {
                    case CONST: 
                    case CONST_16: 
                    case CONST_4: 
                    case CONST_HIGH16: {
                        return this.b((Value)Exprs.nInt((int)((Integer)((ConstStmtNode)insn).value)));
                    }
                    case CONST_WIDE: 
                    case CONST_WIDE_16: 
                    case CONST_WIDE_32: 
                    case CONST_WIDE_HIGH16: {
                        return this.b((Value)Exprs.nLong((long)((Long)((ConstStmtNode)insn).value)));
                    }
                    case CONST_CLASS: {
                        return this.b((Value)Exprs.nType((DexType)((DexType)((ConstStmtNode)insn).value)));
                    }
                    case CONST_STRING: 
                    case CONST_STRING_JUMBO: {
                        return this.b((Value)Exprs.nString((String)((String)((ConstStmtNode)insn).value)));
                    }
                    case CONST_METHOD_HANDLE: {
                        return this.b((Value)Exprs.nMethodHandle((MethodHandle)((MethodHandle)((ConstStmtNode)insn).value)));
                    }
                    case CONST_METHOD_TYPE: {
                        return this.b((Value)Exprs.nProto((Proto)((Proto)((ConstStmtNode)insn).value)));
                    }
                    case SGET: 
                    case SGET_BOOLEAN: 
                    case SGET_BYTE: 
                    case SGET_CHAR: 
                    case SGET_OBJECT: 
                    case SGET_SHORT: 
                    case SGET_WIDE: {
                        Field field = ((FieldStmtNode)insn).field;
                        return this.b((Value)Exprs.nStaticField((String)field.getOwner(), (String)field.getName(), (String)field.getType()));
                    }
                    case NEW_INSTANCE: {
                        return this.b((Value)Exprs.nNew((String)((TypeStmtNode)insn).type));
                    }
                }
                return null;
            }

            public DvmValue copyOperation(DexStmtNode insn, DvmValue value) {
                if (value == null) {
                    this.emitNotFindOperand(insn);
                    return this.b((Value)Exprs.nInt((int)0));
                }
                return this.b((Value)Dex2IRConverter.this.getLocal(value));
            }

            public DvmValue unaryOperation(DexStmtNode insn, DvmValue value) {
                if (value == null) {
                    this.emitNotFindOperand(insn);
                    return this.b((Value)Exprs.nInt((int)0));
                }
                Local local = Dex2IRConverter.this.getLocal(value);
                switch (insn.op) {
                    case NOT_INT: {
                        return this.b((Value)Exprs.nNot((Value)local, (String)"I"));
                    }
                    case NOT_LONG: {
                        return this.b((Value)Exprs.nNot((Value)local, (String)"J"));
                    }
                    case NEG_DOUBLE: {
                        return this.b((Value)Exprs.nNeg((Value)local, (String)"D"));
                    }
                    case NEG_FLOAT: {
                        return this.b((Value)Exprs.nNeg((Value)local, (String)"F"));
                    }
                    case NEG_INT: {
                        return this.b((Value)Exprs.nNeg((Value)local, (String)"I"));
                    }
                    case NEG_LONG: {
                        return this.b((Value)Exprs.nNeg((Value)local, (String)"J"));
                    }
                    case INT_TO_BYTE: {
                        return this.b((Value)Exprs.nCast((Value)local, (String)"I", (String)"B"));
                    }
                    case INT_TO_CHAR: {
                        return this.b((Value)Exprs.nCast((Value)local, (String)"I", (String)"C"));
                    }
                    case INT_TO_DOUBLE: {
                        return this.b((Value)Exprs.nCast((Value)local, (String)"I", (String)"D"));
                    }
                    case INT_TO_FLOAT: {
                        return this.b((Value)Exprs.nCast((Value)local, (String)"I", (String)"F"));
                    }
                    case INT_TO_LONG: {
                        return this.b((Value)Exprs.nCast((Value)local, (String)"I", (String)"J"));
                    }
                    case INT_TO_SHORT: {
                        return this.b((Value)Exprs.nCast((Value)local, (String)"I", (String)"S"));
                    }
                    case FLOAT_TO_DOUBLE: {
                        return this.b((Value)Exprs.nCast((Value)local, (String)"F", (String)"D"));
                    }
                    case FLOAT_TO_INT: {
                        return this.b((Value)Exprs.nCast((Value)local, (String)"F", (String)"I"));
                    }
                    case FLOAT_TO_LONG: {
                        return this.b((Value)Exprs.nCast((Value)local, (String)"F", (String)"J"));
                    }
                    case DOUBLE_TO_FLOAT: {
                        return this.b((Value)Exprs.nCast((Value)local, (String)"D", (String)"F"));
                    }
                    case DOUBLE_TO_INT: {
                        return this.b((Value)Exprs.nCast((Value)local, (String)"D", (String)"I"));
                    }
                    case DOUBLE_TO_LONG: {
                        return this.b((Value)Exprs.nCast((Value)local, (String)"D", (String)"J"));
                    }
                    case LONG_TO_DOUBLE: {
                        return this.b((Value)Exprs.nCast((Value)local, (String)"J", (String)"D"));
                    }
                    case LONG_TO_FLOAT: {
                        return this.b((Value)Exprs.nCast((Value)local, (String)"J", (String)"F"));
                    }
                    case LONG_TO_INT: {
                        return this.b((Value)Exprs.nCast((Value)local, (String)"J", (String)"I"));
                    }
                    case ARRAY_LENGTH: {
                        return this.b((Value)Exprs.nLength((Value)local));
                    }
                    case IF_EQZ: {
                        Dex2IRConverter.this.emit((Stmt)Stmts.nIf((Value)Exprs.nEq((Value)local, (Value)Exprs.nInt((int)0), (String)TypeClass.ZIL.name), (LabelStmt)Dex2IRConverter.this.getLabel(((JumpStmtNode)insn).label)));
                        return null;
                    }
                    case IF_GEZ: {
                        Dex2IRConverter.this.emit((Stmt)Stmts.nIf((Value)Exprs.nGe((Value)local, (Value)Exprs.nInt((int)0), (String)"I"), (LabelStmt)Dex2IRConverter.this.getLabel(((JumpStmtNode)insn).label)));
                        return null;
                    }
                    case IF_GTZ: {
                        Dex2IRConverter.this.emit((Stmt)Stmts.nIf((Value)Exprs.nGt((Value)local, (Value)Exprs.nInt((int)0), (String)"I"), (LabelStmt)Dex2IRConverter.this.getLabel(((JumpStmtNode)insn).label)));
                        return null;
                    }
                    case IF_LEZ: {
                        Dex2IRConverter.this.emit((Stmt)Stmts.nIf((Value)Exprs.nLe((Value)local, (Value)Exprs.nInt((int)0), (String)"I"), (LabelStmt)Dex2IRConverter.this.getLabel(((JumpStmtNode)insn).label)));
                        return null;
                    }
                    case IF_LTZ: {
                        Dex2IRConverter.this.emit((Stmt)Stmts.nIf((Value)Exprs.nLt((Value)local, (Value)Exprs.nInt((int)0), (String)"I"), (LabelStmt)Dex2IRConverter.this.getLabel(((JumpStmtNode)insn).label)));
                        return null;
                    }
                    case IF_NEZ: {
                        Dex2IRConverter.this.emit((Stmt)Stmts.nIf((Value)Exprs.nNe((Value)local, (Value)Exprs.nInt((int)0), (String)TypeClass.ZIL.name), (LabelStmt)Dex2IRConverter.this.getLabel(((JumpStmtNode)insn).label)));
                        return null;
                    }
                    case PACKED_SWITCH: 
                    case SPARSE_SWITCH: {
                        DexLabel[] labels = ((BaseSwitchStmtNode)insn).labels;
                        LabelStmt[] lss = new LabelStmt[labels.length];
                        for (int i = 0; i < labels.length; ++i) {
                            lss[i] = Dex2IRConverter.this.getLabel(labels[i]);
                        }
                        LabelStmt d = new LabelStmt();
                        if (insn.op == Op.PACKED_SWITCH) {
                            Dex2IRConverter.this.emit((Stmt)Stmts.nTableSwitch((Value)local, (int)((PackedSwitchStmtNode)insn).firstCase, (LabelStmt[])lss, (LabelStmt)d));
                        } else {
                            Dex2IRConverter.this.emit((Stmt)Stmts.nLookupSwitch((Value)local, (int[])((SparseSwitchStmtNode)insn).cases, (LabelStmt[])lss, (LabelStmt)d));
                        }
                        Dex2IRConverter.this.emit((Stmt)d);
                        return null;
                    }
                    case SPUT: 
                    case SPUT_BOOLEAN: 
                    case SPUT_BYTE: 
                    case SPUT_CHAR: 
                    case SPUT_OBJECT: 
                    case SPUT_SHORT: 
                    case SPUT_WIDE: {
                        Field field = ((FieldStmtNode)insn).field;
                        Dex2IRConverter.this.emit((Stmt)Stmts.nAssign((Value)Exprs.nStaticField((String)field.getOwner(), (String)field.getName(), (String)field.getType()), (Value)local));
                        return null;
                    }
                    case IGET: 
                    case IGET_BOOLEAN: 
                    case IGET_BYTE: 
                    case IGET_CHAR: 
                    case IGET_OBJECT: 
                    case IGET_SHORT: 
                    case IGET_WIDE: {
                        Field field = ((FieldStmtNode)insn).field;
                        return this.b((Value)Exprs.nField((Value)local, (String)field.getOwner(), (String)field.getName(), (String)field.getType()));
                    }
                    case INSTANCE_OF: {
                        return this.b((Value)Exprs.nInstanceOf((Value)local, (String)((TypeStmtNode)insn).type));
                    }
                    case NEW_ARRAY: {
                        return this.b((Value)Exprs.nNewArray((String)((TypeStmtNode)insn).type.substring(1), (Value)local));
                    }
                    case CHECK_CAST: {
                        return this.b((Value)Exprs.nCheckCast((Value)local, (String)((TypeStmtNode)insn).type));
                    }
                    case MONITOR_ENTER: {
                        Dex2IRConverter.this.emit((Stmt)Stmts.nLock((Value)local));
                        return null;
                    }
                    case MONITOR_EXIT: {
                        Dex2IRConverter.this.emit((Stmt)Stmts.nUnLock((Value)local));
                        return null;
                    }
                    case THROW: {
                        Dex2IRConverter.this.emit((Stmt)Stmts.nThrow((Value)local));
                        return null;
                    }
                    case ADD_INT_LIT16: 
                    case ADD_INT_LIT8: {
                        return this.b((Value)Exprs.nAdd((Value)local, (Value)Exprs.nInt((int)((Stmt2R1NNode)insn).content), (String)"I"));
                    }
                    case RSUB_INT_LIT8: 
                    case RSUB_INT: {
                        return this.b((Value)Exprs.nSub((Value)Exprs.nInt((int)((Stmt2R1NNode)insn).content), (Value)local, (String)"I"));
                    }
                    case MUL_INT_LIT8: 
                    case MUL_INT_LIT16: {
                        return this.b((Value)Exprs.nMul((Value)local, (Value)Exprs.nInt((int)((Stmt2R1NNode)insn).content), (String)"I"));
                    }
                    case DIV_INT_LIT16: 
                    case DIV_INT_LIT8: {
                        return this.b((Value)Exprs.nDiv((Value)local, (Value)Exprs.nInt((int)((Stmt2R1NNode)insn).content), (String)"I"));
                    }
                    case REM_INT_LIT16: 
                    case REM_INT_LIT8: {
                        return this.b((Value)Exprs.nRem((Value)local, (Value)Exprs.nInt((int)((Stmt2R1NNode)insn).content), (String)"I"));
                    }
                    case AND_INT_LIT16: 
                    case AND_INT_LIT8: {
                        return this.b((Value)Exprs.nAnd((Value)local, (Value)Exprs.nInt((int)((Stmt2R1NNode)insn).content), (String)(((Stmt2R1NNode)insn).content < 0 || ((Stmt2R1NNode)insn).content > 1 ? "I" : TypeClass.ZI.name)));
                    }
                    case OR_INT_LIT16: 
                    case OR_INT_LIT8: {
                        return this.b((Value)Exprs.nOr((Value)local, (Value)Exprs.nInt((int)((Stmt2R1NNode)insn).content), (String)(((Stmt2R1NNode)insn).content < 0 || ((Stmt2R1NNode)insn).content > 1 ? "I" : TypeClass.ZI.name)));
                    }
                    case XOR_INT_LIT16: 
                    case XOR_INT_LIT8: {
                        return this.b((Value)Exprs.nXor((Value)local, (Value)Exprs.nInt((int)((Stmt2R1NNode)insn).content), (String)(((Stmt2R1NNode)insn).content < 0 || ((Stmt2R1NNode)insn).content > 1 ? "I" : TypeClass.ZI.name)));
                    }
                    case SHL_INT_LIT8: {
                        return this.b((Value)Exprs.nShl((Value)local, (Value)Exprs.nInt((int)((Stmt2R1NNode)insn).content), (String)"I"));
                    }
                    case SHR_INT_LIT8: {
                        return this.b((Value)Exprs.nShr((Value)local, (Value)Exprs.nInt((int)((Stmt2R1NNode)insn).content), (String)"I"));
                    }
                    case USHR_INT_LIT8: {
                        return this.b((Value)Exprs.nUshr((Value)local, (Value)Exprs.nInt((int)((Stmt2R1NNode)insn).content), (String)"I"));
                    }
                    case FILL_ARRAY_DATA: {
                        Dex2IRConverter.this.emit((Stmt)Stmts.nFillArrayData((Value)local, (Value)Exprs.nArrayValue((Object)((FillArrayDataStmtNode)insn).array)));
                        return null;
                    }
                }
                throw new RuntimeException();
            }

            public DvmValue binaryOperation(DexStmtNode insn, DvmValue value1, DvmValue value2) {
                if (value1 == null || value2 == null) {
                    this.emitNotFindOperand(insn);
                    return this.b((Value)Exprs.nInt((int)0));
                }
                Local local1 = Dex2IRConverter.this.getLocal(value1);
                Local local2 = Dex2IRConverter.this.getLocal(value2);
                switch (insn.op) {
                    case AGET: {
                        return this.b((Value)Exprs.nArray((Value)local1, (Value)local2, (String)TypeClass.IF.name));
                    }
                    case AGET_BOOLEAN: {
                        return this.b((Value)Exprs.nArray((Value)local1, (Value)local2, (String)"Z"));
                    }
                    case AGET_BYTE: {
                        return this.b((Value)Exprs.nArray((Value)local1, (Value)local2, (String)"B"));
                    }
                    case AGET_CHAR: {
                        return this.b((Value)Exprs.nArray((Value)local1, (Value)local2, (String)"C"));
                    }
                    case AGET_OBJECT: {
                        return this.b((Value)Exprs.nArray((Value)local1, (Value)local2, (String)"L"));
                    }
                    case AGET_SHORT: {
                        return this.b((Value)Exprs.nArray((Value)local1, (Value)local2, (String)"S"));
                    }
                    case AGET_WIDE: {
                        return this.b((Value)Exprs.nArray((Value)local1, (Value)local2, (String)TypeClass.JD.name));
                    }
                    case CMP_LONG: {
                        return this.b((Value)Exprs.nLCmp((Value)local1, (Value)local2));
                    }
                    case CMPG_DOUBLE: {
                        return this.b((Value)Exprs.nDCmpg((Value)local1, (Value)local2));
                    }
                    case CMPG_FLOAT: {
                        return this.b((Value)Exprs.nFCmpg((Value)local1, (Value)local2));
                    }
                    case CMPL_DOUBLE: {
                        return this.b((Value)Exprs.nDCmpl((Value)local1, (Value)local2));
                    }
                    case CMPL_FLOAT: {
                        return this.b((Value)Exprs.nFCmpl((Value)local1, (Value)local2));
                    }
                    case ADD_DOUBLE: {
                        return this.b((Value)Exprs.nAdd((Value)local1, (Value)local2, (String)"D"));
                    }
                    case ADD_FLOAT: {
                        return this.b((Value)Exprs.nAdd((Value)local1, (Value)local2, (String)"F"));
                    }
                    case ADD_INT: {
                        return this.b((Value)Exprs.nAdd((Value)local1, (Value)local2, (String)"I"));
                    }
                    case ADD_LONG: {
                        return this.b((Value)Exprs.nAdd((Value)local1, (Value)local2, (String)"J"));
                    }
                    case SUB_DOUBLE: {
                        return this.b((Value)Exprs.nSub((Value)local1, (Value)local2, (String)"D"));
                    }
                    case SUB_FLOAT: {
                        return this.b((Value)Exprs.nSub((Value)local1, (Value)local2, (String)"F"));
                    }
                    case SUB_INT: {
                        return this.b((Value)Exprs.nSub((Value)local1, (Value)local2, (String)"I"));
                    }
                    case SUB_LONG: {
                        return this.b((Value)Exprs.nSub((Value)local1, (Value)local2, (String)"J"));
                    }
                    case MUL_DOUBLE: {
                        return this.b((Value)Exprs.nMul((Value)local1, (Value)local2, (String)"D"));
                    }
                    case MUL_FLOAT: {
                        return this.b((Value)Exprs.nMul((Value)local1, (Value)local2, (String)"F"));
                    }
                    case MUL_INT: {
                        return this.b((Value)Exprs.nMul((Value)local1, (Value)local2, (String)"I"));
                    }
                    case MUL_LONG: {
                        return this.b((Value)Exprs.nMul((Value)local1, (Value)local2, (String)"J"));
                    }
                    case DIV_DOUBLE: {
                        return this.b((Value)Exprs.nDiv((Value)local1, (Value)local2, (String)"D"));
                    }
                    case DIV_FLOAT: {
                        return this.b((Value)Exprs.nDiv((Value)local1, (Value)local2, (String)"F"));
                    }
                    case DIV_INT: {
                        return this.b((Value)Exprs.nDiv((Value)local1, (Value)local2, (String)"I"));
                    }
                    case DIV_LONG: {
                        return this.b((Value)Exprs.nDiv((Value)local1, (Value)local2, (String)"J"));
                    }
                    case REM_DOUBLE: {
                        return this.b((Value)Exprs.nRem((Value)local1, (Value)local2, (String)"D"));
                    }
                    case REM_FLOAT: {
                        return this.b((Value)Exprs.nRem((Value)local1, (Value)local2, (String)"F"));
                    }
                    case REM_INT: {
                        return this.b((Value)Exprs.nRem((Value)local1, (Value)local2, (String)"I"));
                    }
                    case REM_LONG: {
                        return this.b((Value)Exprs.nRem((Value)local1, (Value)local2, (String)"J"));
                    }
                    case AND_INT: {
                        return this.b((Value)Exprs.nAnd((Value)local1, (Value)local2, (String)TypeClass.ZI.name));
                    }
                    case AND_LONG: {
                        return this.b((Value)Exprs.nAnd((Value)local1, (Value)local2, (String)"J"));
                    }
                    case OR_INT: {
                        return this.b((Value)Exprs.nOr((Value)local1, (Value)local2, (String)TypeClass.ZI.name));
                    }
                    case OR_LONG: {
                        return this.b((Value)Exprs.nOr((Value)local1, (Value)local2, (String)"J"));
                    }
                    case XOR_INT: {
                        return this.b((Value)Exprs.nXor((Value)local1, (Value)local2, (String)TypeClass.ZI.name));
                    }
                    case XOR_LONG: {
                        return this.b((Value)Exprs.nXor((Value)local1, (Value)local2, (String)"J"));
                    }
                    case SHL_INT: {
                        return this.b((Value)Exprs.nShl((Value)local1, (Value)local2, (String)"I"));
                    }
                    case SHL_LONG: {
                        return this.b((Value)Exprs.nShl((Value)local1, (Value)local2, (String)"J"));
                    }
                    case SHR_INT: {
                        return this.b((Value)Exprs.nShr((Value)local1, (Value)local2, (String)"I"));
                    }
                    case SHR_LONG: {
                        return this.b((Value)Exprs.nShr((Value)local1, (Value)local2, (String)"J"));
                    }
                    case USHR_INT: {
                        return this.b((Value)Exprs.nUshr((Value)local1, (Value)local2, (String)"I"));
                    }
                    case USHR_LONG: {
                        return this.b((Value)Exprs.nUshr((Value)local1, (Value)local2, (String)"J"));
                    }
                    case IF_EQ: {
                        Dex2IRConverter.this.emit((Stmt)Stmts.nIf((Value)Exprs.nEq((Value)local1, (Value)local2, (String)TypeClass.ZIL.name), (LabelStmt)Dex2IRConverter.this.getLabel(((JumpStmtNode)insn).label)));
                        return null;
                    }
                    case IF_GE: {
                        Dex2IRConverter.this.emit((Stmt)Stmts.nIf((Value)Exprs.nGe((Value)local1, (Value)local2, (String)"I"), (LabelStmt)Dex2IRConverter.this.getLabel(((JumpStmtNode)insn).label)));
                        return null;
                    }
                    case IF_GT: {
                        Dex2IRConverter.this.emit((Stmt)Stmts.nIf((Value)Exprs.nGt((Value)local1, (Value)local2, (String)"I"), (LabelStmt)Dex2IRConverter.this.getLabel(((JumpStmtNode)insn).label)));
                        return null;
                    }
                    case IF_LE: {
                        Dex2IRConverter.this.emit((Stmt)Stmts.nIf((Value)Exprs.nLe((Value)local1, (Value)local2, (String)"I"), (LabelStmt)Dex2IRConverter.this.getLabel(((JumpStmtNode)insn).label)));
                        return null;
                    }
                    case IF_LT: {
                        Dex2IRConverter.this.emit((Stmt)Stmts.nIf((Value)Exprs.nLt((Value)local1, (Value)local2, (String)"I"), (LabelStmt)Dex2IRConverter.this.getLabel(((JumpStmtNode)insn).label)));
                        return null;
                    }
                    case IF_NE: {
                        Dex2IRConverter.this.emit((Stmt)Stmts.nIf((Value)Exprs.nNe((Value)local1, (Value)local2, (String)TypeClass.ZIL.name), (LabelStmt)Dex2IRConverter.this.getLabel(((JumpStmtNode)insn).label)));
                        return null;
                    }
                    case IPUT: 
                    case IPUT_BOOLEAN: 
                    case IPUT_BYTE: 
                    case IPUT_CHAR: 
                    case IPUT_OBJECT: 
                    case IPUT_SHORT: 
                    case IPUT_WIDE: {
                        Field field = ((FieldStmtNode)insn).field;
                        Dex2IRConverter.this.emit((Stmt)Stmts.nAssign((Value)Exprs.nField((Value)local1, (String)field.getOwner(), (String)field.getName(), (String)field.getType()), (Value)local2));
                        return null;
                    }
                    case ADD_DOUBLE_2ADDR: {
                        return this.b((Value)Exprs.nAdd((Value)local1, (Value)local2, (String)"D"));
                    }
                    case ADD_FLOAT_2ADDR: {
                        return this.b((Value)Exprs.nAdd((Value)local1, (Value)local2, (String)"F"));
                    }
                    case ADD_INT_2ADDR: {
                        return this.b((Value)Exprs.nAdd((Value)local1, (Value)local2, (String)"I"));
                    }
                    case ADD_LONG_2ADDR: {
                        return this.b((Value)Exprs.nAdd((Value)local1, (Value)local2, (String)"J"));
                    }
                    case SUB_DOUBLE_2ADDR: {
                        return this.b((Value)Exprs.nSub((Value)local1, (Value)local2, (String)"D"));
                    }
                    case SUB_FLOAT_2ADDR: {
                        return this.b((Value)Exprs.nSub((Value)local1, (Value)local2, (String)"F"));
                    }
                    case SUB_INT_2ADDR: {
                        return this.b((Value)Exprs.nSub((Value)local1, (Value)local2, (String)"I"));
                    }
                    case SUB_LONG_2ADDR: {
                        return this.b((Value)Exprs.nSub((Value)local1, (Value)local2, (String)"J"));
                    }
                    case MUL_DOUBLE_2ADDR: {
                        return this.b((Value)Exprs.nMul((Value)local1, (Value)local2, (String)"D"));
                    }
                    case MUL_FLOAT_2ADDR: {
                        return this.b((Value)Exprs.nMul((Value)local1, (Value)local2, (String)"F"));
                    }
                    case MUL_INT_2ADDR: {
                        return this.b((Value)Exprs.nMul((Value)local1, (Value)local2, (String)"I"));
                    }
                    case MUL_LONG_2ADDR: {
                        return this.b((Value)Exprs.nMul((Value)local1, (Value)local2, (String)"J"));
                    }
                    case DIV_DOUBLE_2ADDR: {
                        return this.b((Value)Exprs.nDiv((Value)local1, (Value)local2, (String)"D"));
                    }
                    case DIV_FLOAT_2ADDR: {
                        return this.b((Value)Exprs.nDiv((Value)local1, (Value)local2, (String)"F"));
                    }
                    case DIV_INT_2ADDR: {
                        return this.b((Value)Exprs.nDiv((Value)local1, (Value)local2, (String)"I"));
                    }
                    case DIV_LONG_2ADDR: {
                        return this.b((Value)Exprs.nDiv((Value)local1, (Value)local2, (String)"J"));
                    }
                    case REM_DOUBLE_2ADDR: {
                        return this.b((Value)Exprs.nRem((Value)local1, (Value)local2, (String)"D"));
                    }
                    case REM_FLOAT_2ADDR: {
                        return this.b((Value)Exprs.nRem((Value)local1, (Value)local2, (String)"F"));
                    }
                    case REM_INT_2ADDR: {
                        return this.b((Value)Exprs.nRem((Value)local1, (Value)local2, (String)"I"));
                    }
                    case REM_LONG_2ADDR: {
                        return this.b((Value)Exprs.nRem((Value)local1, (Value)local2, (String)"J"));
                    }
                    case AND_INT_2ADDR: {
                        return this.b((Value)Exprs.nAnd((Value)local1, (Value)local2, (String)TypeClass.ZI.name));
                    }
                    case AND_LONG_2ADDR: {
                        return this.b((Value)Exprs.nAnd((Value)local1, (Value)local2, (String)"J"));
                    }
                    case OR_INT_2ADDR: {
                        return this.b((Value)Exprs.nOr((Value)local1, (Value)local2, (String)TypeClass.ZI.name));
                    }
                    case OR_LONG_2ADDR: {
                        return this.b((Value)Exprs.nOr((Value)local1, (Value)local2, (String)"J"));
                    }
                    case XOR_INT_2ADDR: {
                        return this.b((Value)Exprs.nXor((Value)local1, (Value)local2, (String)TypeClass.ZI.name));
                    }
                    case XOR_LONG_2ADDR: {
                        return this.b((Value)Exprs.nXor((Value)local1, (Value)local2, (String)"J"));
                    }
                    case SHL_INT_2ADDR: {
                        return this.b((Value)Exprs.nShl((Value)local1, (Value)local2, (String)"I"));
                    }
                    case SHL_LONG_2ADDR: {
                        return this.b((Value)Exprs.nShl((Value)local1, (Value)local2, (String)"J"));
                    }
                    case SHR_INT_2ADDR: {
                        return this.b((Value)Exprs.nShr((Value)local1, (Value)local2, (String)"I"));
                    }
                    case SHR_LONG_2ADDR: {
                        return this.b((Value)Exprs.nShr((Value)local1, (Value)local2, (String)"J"));
                    }
                    case USHR_INT_2ADDR: {
                        return this.b((Value)Exprs.nUshr((Value)local1, (Value)local2, (String)"I"));
                    }
                    case USHR_LONG_2ADDR: {
                        return this.b((Value)Exprs.nUshr((Value)local1, (Value)local2, (String)"J"));
                    }
                }
                throw new RuntimeException();
            }

            public DvmValue ternaryOperation(DexStmtNode insn, DvmValue value1, DvmValue value2, DvmValue value3) {
                if (value1 == null || value2 == null || value3 == null) {
                    this.emitNotFindOperand(insn);
                    return this.b((Value)Exprs.nInt((int)0));
                }
                Local localArray = Dex2IRConverter.this.getLocal(value1);
                Local localIndex = Dex2IRConverter.this.getLocal(value2);
                Local localValue = Dex2IRConverter.this.getLocal(value3);
                switch (insn.op) {
                    case APUT: {
                        Dex2IRConverter.this.emit((Stmt)Stmts.nAssign((Value)Exprs.nArray((Value)localArray, (Value)localIndex, (String)TypeClass.IF.name), (Value)localValue));
                        break;
                    }
                    case APUT_BOOLEAN: {
                        Dex2IRConverter.this.emit((Stmt)Stmts.nAssign((Value)Exprs.nArray((Value)localArray, (Value)localIndex, (String)"Z"), (Value)localValue));
                        break;
                    }
                    case APUT_BYTE: {
                        Dex2IRConverter.this.emit((Stmt)Stmts.nAssign((Value)Exprs.nArray((Value)localArray, (Value)localIndex, (String)"B"), (Value)localValue));
                        break;
                    }
                    case APUT_CHAR: {
                        Dex2IRConverter.this.emit((Stmt)Stmts.nAssign((Value)Exprs.nArray((Value)localArray, (Value)localIndex, (String)"C"), (Value)localValue));
                        break;
                    }
                    case APUT_OBJECT: {
                        Dex2IRConverter.this.emit((Stmt)Stmts.nAssign((Value)Exprs.nArray((Value)localArray, (Value)localIndex, (String)"L"), (Value)localValue));
                        break;
                    }
                    case APUT_SHORT: {
                        Dex2IRConverter.this.emit((Stmt)Stmts.nAssign((Value)Exprs.nArray((Value)localArray, (Value)localIndex, (String)"S"), (Value)localValue));
                        break;
                    }
                    case APUT_WIDE: {
                        Dex2IRConverter.this.emit((Stmt)Stmts.nAssign((Value)Exprs.nArray((Value)localArray, (Value)localIndex, (String)TypeClass.JD.name), (Value)localValue));
                        break;
                    }
                }
                return null;
            }

            public DvmValue naryOperation(DexStmtNode insn, List<? extends DvmValue> values) {
                InvokeExpr invoke;
                for (DvmValue dvmValue : values) {
                    if (dvmValue != null) continue;
                    this.emitNotFindOperand(insn);
                    return this.b((Value)Exprs.nInt((int)0));
                }
                switch (insn.op) {
                    case FILLED_NEW_ARRAY: 
                    case FILLED_NEW_ARRAY_RANGE: {
                        DvmValue value = new DvmValue();
                        FilledNewArrayStmtNode filledNewArrayStmtNode = (FilledNewArrayStmtNode)insn;
                        String type = filledNewArrayStmtNode.type;
                        String elem = type.substring(1);
                        Dex2IRConverter.this.emit((Stmt)Stmts.nAssign((Value)Dex2IRConverter.this.getLocal(value), (Value)Exprs.nNewArray((String)elem, (Value)Exprs.nInt((int)values.size()))));
                        for (int i = 0; i < values.size(); ++i) {
                            Dex2IRConverter.this.emit((Stmt)Stmts.nAssign((Value)Exprs.nArray((Value)Dex2IRConverter.this.getLocal(value), (Value)Exprs.nInt((int)i), (String)elem), (Value)Dex2IRConverter.this.getLocal(values.get(i))));
                        }
                        return value;
                    }
                    case INVOKE_CUSTOM: 
                    case INVOKE_CUSTOM_RANGE: {
                        Value[] vs = new Value[values.size()];
                        for (int i = 0; i < vs.length; ++i) {
                            vs[i] = Dex2IRConverter.this.getLocal(values.get(i));
                        }
                        MethodCustomStmtNode n = (MethodCustomStmtNode)insn;
                        InvokeCustomExpr invoke2 = Exprs.nInvokeCustom((Value[])vs, (CallSite)n.callSite);
                        if ("V".equals(n.getProto().getReturnType())) {
                            Dex2IRConverter.this.emit((Stmt)Stmts.nVoidInvoke((Value)invoke2));
                            return null;
                        }
                        return this.b((Value)invoke2);
                    }
                    case INVOKE_POLYMORPHIC: 
                    case INVOKE_POLYMORPHIC_RANGE: {
                        Value[] vs = new Value[values.size()];
                        for (int i = 0; i < vs.length; ++i) {
                            vs[i] = Dex2IRConverter.this.getLocal(values.get(i));
                        }
                        MethodPolymorphicStmtNode n = (MethodPolymorphicStmtNode)insn;
                        InvokePolymorphicExpr invoke3 = Exprs.nInvokePolymorphic((Value[])vs, (Proto)n.proto, (Method)n.method);
                        if ("V".equals(n.getProto().getReturnType())) {
                            Dex2IRConverter.this.emit((Stmt)Stmts.nVoidInvoke((Value)invoke3));
                            return null;
                        }
                        return this.b((Value)invoke3);
                    }
                }
                Op op = insn.op;
                Value[] vs = new Value[values.size()];
                for (int i = 0; i < vs.length; ++i) {
                    vs[i] = Dex2IRConverter.this.getLocal(values.get(i));
                }
                Method method = ((MethodStmtNode)insn).method;
                switch (op) {
                    case INVOKE_VIRTUAL_RANGE: 
                    case INVOKE_VIRTUAL: {
                        invoke = Exprs.nInvokeVirtual((Value[])vs, (String)method.getOwner(), (String)method.getName(), (String[])method.getParameterTypes(), (String)method.getReturnType());
                        break;
                    }
                    case INVOKE_SUPER_RANGE: 
                    case INVOKE_DIRECT_RANGE: 
                    case INVOKE_SUPER: 
                    case INVOKE_DIRECT: {
                        invoke = Exprs.nInvokeSpecial((Value[])vs, (String)method.getOwner(), (String)method.getName(), (String[])method.getParameterTypes(), (String)method.getReturnType());
                        break;
                    }
                    case INVOKE_STATIC_RANGE: 
                    case INVOKE_STATIC: {
                        invoke = Exprs.nInvokeStatic((Value[])vs, (String)method.getOwner(), (String)method.getName(), (String[])method.getParameterTypes(), (String)method.getReturnType());
                        break;
                    }
                    case INVOKE_INTERFACE_RANGE: 
                    case INVOKE_INTERFACE: {
                        invoke = Exprs.nInvokeInterface((Value[])vs, (String)method.getOwner(), (String)method.getName(), (String[])method.getParameterTypes(), (String)method.getReturnType());
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                if ("V".equals(method.getReturnType())) {
                    Dex2IRConverter.this.emit((Stmt)Stmts.nVoidInvoke((Value)invoke));
                    return null;
                }
                return this.b((Value)invoke);
            }

            void emitNotFindOperand(DexStmtNode insn) {
                String msg;
                switch (insn.op) {
                    case MOVE_RESULT: 
                    case MOVE_RESULT_OBJECT: 
                    case MOVE_RESULT_WIDE: {
                        msg = "can't get operand(s) for " + insn.op + ", wrong position ?";
                        break;
                    }
                    default: {
                        msg = "can't get operand(s) for " + insn.op + ", out-of-range or not initialized ?";
                    }
                }
                System.err.println("WARN: " + msg);
                Dex2IRConverter.this.emit((Stmt)Stmts.nThrow((Value)Exprs.nInvokeNew((Value[])new Value[]{Exprs.nString((String)("d2j: " + msg))}, (String[])new String[]{"Ljava/lang/String;"}, (String)"Ljava/lang/VerifyError;")));
            }

            public void returnOperation(DexStmtNode insn, DvmValue value) {
                if (value == null) {
                    this.emitNotFindOperand(insn);
                    return;
                }
                Dex2IRConverter.this.emit((Stmt)Stmts.nReturn((Value)Dex2IRConverter.this.getLocal(value)));
            }
        };
    }

    private LabelStmt[] getLabels(DexLabel[] handler) {
        LabelStmt[] ts = new LabelStmt[handler.length];
        for (int i = 0; i < handler.length; ++i) {
            ts[i] = this.getLabel(handler[i]);
        }
        return ts;
    }

    LabelStmt getLabel(DexLabel label) {
        LabelStmt ls = this.map.get(label);
        if (ls == null) {
            ls = Stmts.nLabel();
            this.map.put(label, ls);
        }
        return ls;
    }

    private void initParentCount(int[] parentCount) {
        parentCount[0] = 1;
        for (DexStmtNode p : this.insnList) {
            Op op = p.op;
            if (op == null) {
                if (p.index >= parentCount.length - 1) continue;
                int n = p.index + 1;
                parentCount[n] = parentCount[n] + 1;
                continue;
            }
            if (op.canBranch()) {
                int n = this.indexOf(((JumpStmtNode)p).label);
                parentCount[n] = parentCount[n] + 1;
            }
            if (op.canSwitch()) {
                BaseSwitchStmtNode switchStmtNode = (BaseSwitchStmtNode)p;
                for (DexLabel label : switchStmtNode.labels) {
                    int n = this.indexOf(label);
                    parentCount[n] = parentCount[n] + 1;
                }
            }
            if (!op.canContinue()) continue;
            int n = p.index + 1;
            parentCount[n] = parentCount[n] + 1;
        }
    }

    int indexOf(DexLabel label) {
        DexLabelStmtNode dexLabelStmtNode = this.labelMap.get(label);
        return dexLabelStmtNode.index;
    }

    static class Dex2IrFrame
    extends DvmFrame<DvmValue> {
        Dex2IrFrame(int totalRegister) {
            super(totalRegister);
        }
    }

    static class DvmValue {
        public DvmValue parent;
        public Set<DvmValue> otherParent;
        Local local;

        DvmValue(Local thiz) {
            this.local = thiz;
        }

        DvmValue() {
        }
    }
}

