/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.dex.writer.item;

import com.googlecode.d2j.dex.writer.ev.EncodedArray;
import com.googlecode.d2j.dex.writer.ev.EncodedValue;
import com.googlecode.d2j.dex.writer.io.DataOut;
import com.googlecode.d2j.dex.writer.item.AnnotationSetItem;
import com.googlecode.d2j.dex.writer.item.AnnotationSetRefListItem;
import com.googlecode.d2j.dex.writer.item.AnnotationsDirectoryItem;
import com.googlecode.d2j.dex.writer.item.BaseItem;
import com.googlecode.d2j.dex.writer.item.ClassDataItem;
import com.googlecode.d2j.dex.writer.item.ConstPool;
import com.googlecode.d2j.dex.writer.item.FieldIdItem;
import com.googlecode.d2j.dex.writer.item.MethodIdItem;
import com.googlecode.d2j.dex.writer.item.StringIdItem;
import com.googlecode.d2j.dex.writer.item.TypeIdItem;
import com.googlecode.d2j.dex.writer.item.TypeListItem;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ClassDefItem
extends BaseItem {
    public TypeIdItem clazz;
    public int accessFlags;
    public TypeIdItem superclazz;
    public TypeListItem interfaces;
    public StringIdItem sourceFile;
    public ClassDataItem classData;
    public AnnotationSetItem classAnnotations;
    private AnnotationsDirectoryItem annotations;
    private EncodedArray staticValues;

    @Override
    public int place(int offset) {
        return offset + 32;
    }

    public void prepare(ConstPool cp) {
        if (this.classData != null) {
            this.classData.prepare(cp);
        }
        this.preparteAnnotationsDirectoryItem(cp);
        this.prepareEncodedArrayItem(cp);
    }

    private void prepareEncodedArrayItem(ConstPool cp) {
        if (this.classData == null) {
            return;
        }
        List<ClassDataItem.EncodedField> fs = this.classData.staticFields;
        int count = -1;
        for (int i = 0; i < fs.size(); ++i) {
            ClassDataItem.EncodedField f = fs.get(i);
            EncodedValue ev = f.staticValue;
            if (ev == null || ev.isDefaultValueForType()) continue;
            count = i;
        }
        if (count >= 0) {
            EncodedArray array = new EncodedArray();
            for (int i = 0; i <= count; ++i) {
                ClassDataItem.EncodedField f = fs.get(i);
                EncodedValue ev = f.staticValue;
                if (ev == null) {
                    array.values.add(EncodedValue.defaultValueForType(f.field.getTypeString()));
                    continue;
                }
                array.values.add(ev);
            }
            this.staticValues = cp.uniqEncodedArrayItem(array);
        }
    }

    private void preparteAnnotationsDirectoryItem(ConstPool cp) {
        TreeMap<FieldIdItem, AnnotationSetItem> fieldAnnotations = new TreeMap<FieldIdItem, AnnotationSetItem>();
        TreeMap<MethodIdItem, AnnotationSetItem> methodAnnotations = new TreeMap<MethodIdItem, AnnotationSetItem>();
        TreeMap<MethodIdItem, AnnotationSetRefListItem> parameterAnnotations = new TreeMap<MethodIdItem, AnnotationSetRefListItem>();
        if (this.classData != null) {
            this.collectField(fieldAnnotations, this.classData.staticFields, cp);
            this.collectField(fieldAnnotations, this.classData.instanceFields, cp);
            this.collectMethod(methodAnnotations, parameterAnnotations, this.classData.directMethods, cp);
            this.collectMethod(methodAnnotations, parameterAnnotations, this.classData.virtualMethods, cp);
        }
        if (!(this.classAnnotations == null && fieldAnnotations.isEmpty() && methodAnnotations.isEmpty() && parameterAnnotations.isEmpty())) {
            AnnotationsDirectoryItem annotationsDirectoryItem;
            this.annotations = annotationsDirectoryItem = cp.putAnnotationDirectoryItem();
            if (this.classAnnotations != null) {
                annotationsDirectoryItem.classAnnotations = cp.uniqAnnotationSetItem(this.classAnnotations);
            }
            if (!fieldAnnotations.isEmpty()) {
                annotationsDirectoryItem.fieldAnnotations = fieldAnnotations;
            }
            if (!methodAnnotations.isEmpty()) {
                annotationsDirectoryItem.methodAnnotations = methodAnnotations;
            }
            if (!parameterAnnotations.isEmpty()) {
                annotationsDirectoryItem.parameterAnnotations = parameterAnnotations;
            }
        }
    }

    private void collectMethod(Map<MethodIdItem, AnnotationSetItem> methodAnnotations, Map<MethodIdItem, AnnotationSetRefListItem> parameterAnnotations, List<ClassDataItem.EncodedMethod> ms, ConstPool cp) {
        for (ClassDataItem.EncodedMethod m : ms) {
            if (m.annotationSetItem != null) {
                methodAnnotations.put(m.method, cp.uniqAnnotationSetItem(m.annotationSetItem));
            }
            if (m.parameterAnnotation == null) continue;
            parameterAnnotations.put(m.method, cp.uniqAnnotationSetRefListItem(m.parameterAnnotation));
        }
    }

    private void collectField(Map<FieldIdItem, AnnotationSetItem> fieldAnnotations, List<ClassDataItem.EncodedField> fs, ConstPool cp) {
        for (ClassDataItem.EncodedField f : fs) {
            if (f.annotationSetItem == null) continue;
            fieldAnnotations.put(f.field, cp.uniqAnnotationSetItem(f.annotationSetItem));
        }
    }

    @Override
    public void write(DataOut out) {
        out.uint("class_idx", this.clazz.index);
        out.uint("access_flags", this.accessFlags);
        out.uint("superclass_idx", this.superclazz == null ? -1 : this.superclazz.index);
        out.uint("interfaces_off", this.interfaces == null || this.interfaces.items.isEmpty() ? 0 : this.interfaces.offset);
        out.uint("source_file_idx", this.sourceFile == null ? -1 : this.sourceFile.index);
        out.uint("annotations_off", this.annotations == null ? 0 : this.annotations.offset);
        out.uint("class_data_off", this.classData == null ? 0 : this.classData.offset);
        out.uint("static_values_off", this.staticValues == null ? 0 : this.staticValues.offset);
    }
}

