/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.dex.writer.item;

import com.googlecode.d2j.dex.writer.CodeWriter;
import com.googlecode.d2j.dex.writer.insn.Insn;
import com.googlecode.d2j.dex.writer.insn.JumpOp;
import com.googlecode.d2j.dex.writer.insn.Label;
import com.googlecode.d2j.dex.writer.insn.PreBuildInsn;
import com.googlecode.d2j.dex.writer.io.DataOut;
import com.googlecode.d2j.dex.writer.item.BaseItem;
import com.googlecode.d2j.dex.writer.item.DebugInfoItem;
import com.googlecode.d2j.dex.writer.item.TypeIdItem;
import com.googlecode.d2j.reader.Op;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class CodeItem
extends BaseItem {
    public int registersSize;
    public int insSize;
    public int outsSize;
    public int insnSize;
    public List<TryItem> tries;
    public DebugInfoItem debugInfo;
    public List<Insn> insns;
    public List<EncodedCatchHandler> handlers;
    List<TryItem> tryItems;
    List<Insn> ops;
    List<Insn> tailOps;

    @Override
    public int place(int offset) {
        this.prepareInsns();
        this.prepareTries();
        offset += 16 + this.insnSize * 2;
        if (this.tries != null && !this.tries.isEmpty()) {
            if ((this.insnSize & 1) != 0) {
                offset += 2;
            }
            offset += 8 * this.tries.size();
            if (!this.handlers.isEmpty()) {
                int base = offset;
                offset += CodeItem.lengthOfUleb128(this.handlers.size());
                for (EncodedCatchHandler h : this.handlers) {
                    h.handlerOff = offset - base;
                    int size = h.addPairs.size();
                    offset += CodeItem.lengthOfSleb128(h.catchAll != null ? -size : size);
                    for (EncodedCatchHandler.AddrPair ap : h.addPairs) {
                        offset += CodeItem.lengthOfUleb128(ap.type.index) + CodeItem.lengthOfUleb128(ap.addr.offset);
                    }
                    if (h.catchAll == null) continue;
                    offset += CodeItem.lengthOfUleb128(h.catchAll.offset);
                }
            }
        }
        return offset;
    }

    @Override
    public void write(DataOut out) {
        out.ushort("registers_size", this.registersSize);
        out.ushort("ins_size", this.insSize);
        out.ushort("outs_size", this.outsSize);
        out.ushort("tries_size", this.tries == null ? 0 : this.tries.size());
        out.uint("debug_info_off", this.debugInfo == null ? 0 : this.debugInfo.offset);
        out.uint("insn_size", this.insnSize);
        ByteBuffer b = ByteBuffer.allocate(this.insnSize * 2).order(ByteOrder.LITTLE_ENDIAN);
        for (Insn insn : this.insns) {
            insn.write(b);
        }
        out.bytes("insn", b.array());
        if (this.tries != null && !this.tries.isEmpty()) {
            if ((this.insnSize & 1) != 0) {
                out.skip("padding", 2);
            }
            int lastEnd = 0;
            for (TryItem ti : this.tries) {
                if (ti.start.offset < lastEnd) {
                    System.err.println("'Out-of-order try' may throwed by libdex");
                }
                out.uint("start_addr", ti.start.offset);
                out.ushort("insn_count", ti.end.offset - ti.start.offset);
                lastEnd = ti.end.offset;
                out.ushort("handler_off", ti.handler.handlerOff);
            }
            if (!this.handlers.isEmpty()) {
                out.uleb128("size", this.handlers.size());
                for (EncodedCatchHandler h : this.handlers) {
                    int size = h.addPairs.size();
                    out.sleb128("size", h.catchAll != null ? -size : size);
                    for (EncodedCatchHandler.AddrPair ap : h.addPairs) {
                        out.uleb128("type_idx", ap.type.index);
                        out.uleb128("addr", ap.addr.offset);
                    }
                    if (h.catchAll == null) continue;
                    out.uleb128("catch_all_addr", h.catchAll.offset);
                }
            }
        }
    }

    public void init(List<Insn> ops, List<Insn> tailOps, List<TryItem> tryItems) {
        this.ops = ops;
        this.tailOps = tailOps;
        this.tryItems = tryItems;
    }

    private void prepareTries() {
        if (!this.tryItems.isEmpty()) {
            ArrayList<TryItem> uniqTrys = new ArrayList<TryItem>();
            HashSet<TryItem> set = new HashSet<TryItem>();
            for (TryItem tryItem : this.tryItems) {
                if (!set.contains(tryItem)) {
                    uniqTrys.add(tryItem);
                    set.add(tryItem);
                    continue;
                }
                for (TryItem t : uniqTrys) {
                    if (!t.equals(tryItem)) continue;
                    this.mergeExceptionHandler(t.handler, tryItem.handler);
                }
            }
            set.clear();
            this.tries = uniqTrys;
            if (!uniqTrys.isEmpty()) {
                uniqTrys.sort(Comparator.comparingInt(o -> o.start.offset).thenComparingInt(o -> o.end.offset));
            }
            ArrayList<EncodedCatchHandler> uniqHanders = new ArrayList<EncodedCatchHandler>();
            HashMap<EncodedCatchHandler, EncodedCatchHandler> map = new HashMap<EncodedCatchHandler, EncodedCatchHandler>();
            for (TryItem tryItem : uniqTrys) {
                EncodedCatchHandler d = tryItem.handler;
                EncodedCatchHandler uH = (EncodedCatchHandler)map.get(d);
                if (uH != null) {
                    tryItem.handler = uH;
                    continue;
                }
                uniqHanders.add(d);
                map.put(d, d);
            }
            this.handlers = uniqHanders;
            map.clear();
        }
    }

    private void mergeExceptionHandler(EncodedCatchHandler to, EncodedCatchHandler from) {
        for (EncodedCatchHandler.AddrPair pair : from.addPairs) {
            if (to.addPairs.contains(pair)) continue;
            to.addPairs.add(pair);
        }
        if (to.catchAll == null) {
            to.catchAll = from.catchAll;
        }
    }

    private void prepareInsns() {
        ArrayList<JumpOp> jumpOps = new ArrayList<JumpOp>();
        for (Insn insn : this.ops) {
            if (insn instanceof CodeWriter.IndexedInsn) {
                ((CodeWriter.IndexedInsn)insn).fit();
                continue;
            }
            if (!(insn instanceof JumpOp)) continue;
            jumpOps.add((JumpOp)insn);
        }
        int codeSize = 0;
        while (true) {
            for (Insn insn : this.ops) {
                insn.offset = codeSize;
                codeSize += insn.getCodeUnitSize();
            }
            boolean allfit = true;
            for (JumpOp jop : jumpOps) {
                if (jop.fit()) continue;
                allfit = false;
            }
            if (allfit) break;
            codeSize = 0;
        }
        for (Insn insn : this.tailOps) {
            if ((codeSize & 1) != 0) {
                PreBuildInsn nop = new PreBuildInsn(new byte[]{(byte)Op.NOP.opcode, 0});
                insn.offset = codeSize;
                codeSize += ((Insn)nop).getCodeUnitSize();
                this.ops.add(nop);
            }
            insn.offset = codeSize;
            codeSize += insn.getCodeUnitSize();
            this.ops.add(insn);
        }
        this.tailOps.clear();
        this.insns = this.ops;
        this.insnSize = codeSize;
    }

    public static class EncodedCatchHandler {
        public int handlerOff;
        public List<AddrPair> addPairs;
        public Label catchAll;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EncodedCatchHandler that = (EncodedCatchHandler)o;
            if (!this.addPairs.equals(that.addPairs)) {
                return false;
            }
            return Objects.equals(this.catchAll, that.catchAll);
        }

        public int hashCode() {
            int result = this.addPairs.hashCode();
            result = 31 * result + (this.catchAll != null ? this.catchAll.offset : 0);
            return result;
        }

        public static class AddrPair {
            public final TypeIdItem type;
            public final Label addr;

            public AddrPair(TypeIdItem type, Label addr) {
                this.type = type;
                this.addr = addr;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                AddrPair addrPair = (AddrPair)o;
                if (this.addr.offset != addrPair.addr.offset) {
                    return false;
                }
                return this.type.equals(addrPair.type);
            }

            public int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + this.addr.offset;
                return result;
            }
        }
    }

    public static class TryItem {
        public Label start;
        public Label end;
        public EncodedCatchHandler handler;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TryItem tryItem = (TryItem)o;
            if (this.end.offset != tryItem.end.offset) {
                return false;
            }
            return this.start.offset == tryItem.start.offset;
        }

        public int hashCode() {
            int result = this.start.offset;
            result = 31 * result + this.end.offset;
            return result;
        }
    }
}

