/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.dex.writer.item;

import com.googlecode.d2j.dex.writer.io.DataOut;
import com.googlecode.d2j.dex.writer.item.BaseItem;
import com.googlecode.d2j.dex.writer.item.SectionItem;
import java.util.ArrayList;
import java.util.List;

public class MapListItem
extends BaseItem {
    public final List<SectionItem<?>> items = new ArrayList();

    public int getSize() {
        return 4 + this.items.size() * 12;
    }

    public void writeMapItem(DataOut out, int type, int size, int offset) {
        out.begin("map_item");
        out.ushort("type", type);
        out.ushort("unused", 0);
        out.uint("size", size);
        out.uint("offset", offset);
        out.end();
    }

    public void cleanZeroSizeEntry() {
        this.items.removeIf(i -> i == null || i.items.isEmpty());
    }

    @Override
    public void write(DataOut out) {
        out.begin("map_list");
        out.uint("size", this.items.size());
        for (SectionItem<?> t : this.items) {
            this.writeMapItem(out, t.sectionType.code, t.items.size(), t.offset);
        }
        out.end();
        this.items.clear();
    }

    @Override
    public int place(int offset) {
        return offset + 4 + this.items.size() * 12;
    }
}

