/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.util;

import com.googlecode.d2j.reader.DexFileReader;
import com.googlecode.d2j.reader.zip.ZipUtil;
import com.googlecode.d2j.util.ASMifierClassV;
import com.googlecode.d2j.util.ArrayOut;
import com.googlecode.d2j.visitors.DexClassVisitor;
import com.googlecode.d2j.visitors.DexFileVisitor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;

public class ASMifierFileV
extends DexFileVisitor {
    String pkgName = "dex2jar.gen";
    Path dir;
    ArrayOut file = new ArrayOut();
    int i = 0;

    public static void doData(byte[] data, Path destdir) {
        new DexFileReader(data).accept(new ASMifierFileV(destdir, null));
    }

    public static void doFile(Path srcDex) throws IOException {
        String distName = srcDex.getFileName() + "_asmifier";
        ASMifierFileV.doFile(srcDex, srcDex.resolveSibling(distName));
    }

    public static void doFile(Path srcDex, Path dest) throws IOException {
        ASMifierFileV.doData(ZipUtil.readDex(srcDex), dest);
    }

    public static void main(String ... args) throws IOException {
        if (args.length < 1) {
            System.out.println("ASMifier 1.dex 2.dex ... n.dex");
            return;
        }
        for (String s : args) {
            System.out.println("asmifier " + s);
            ASMifierFileV.doFile(new File(s).toPath());
        }
    }

    public ASMifierFileV(Path dir, String pkgName) {
        this.dir = dir == null ? new File(".").toPath() : dir;
        if (pkgName != null) {
            this.pkgName = pkgName;
        }
        this.file.s("package %s;", this.pkgName);
        this.file.s("import com.googlecode.d2j.*;");
        this.file.s("import com.googlecode.dj2.visitors.*;");
        this.file.s("public class Main {");
        this.file.push();
        this.file.s("public static void accept(DexFileVisitor v) {");
        this.file.push();
    }

    static void write(ArrayOut out, Path file) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> list = new ArrayList<String>(out.array.size());
        for (int i = 0; i < out.array.size(); ++i) {
            sb.setLength(0);
            int p = out.is.get(i);
            for (int j = 0; j < p; ++j) {
                sb.append("    ");
            }
            sb.append(out.array.get(i));
            list.add(sb.toString());
        }
        try {
            Path parent = file.getParent();
            if (parent != null && !Files.exists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            Files.write(file, list, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public DexClassVisitor visit(int accessFlags, String className, String superClass, String[] interfaceNames) {
        final String n = String.format("C%04d_", this.i++) + className.substring(1, className.length() - 1).replace('/', '_').replace('$', '_');
        this.file.s("%s.accept(v);", n);
        return new ASMifierClassV(this, this.pkgName, n, accessFlags, className, superClass, interfaceNames){
            final /* synthetic */ ASMifierFileV this$0;
            {
                this.this$0 = this$0;
                super(pkgName, javaClassName, accessFlags, className, superClass, interfaceNames);
            }

            @Override
            public void visitEnd() {
                super.visitEnd();
                ASMifierFileV.write(this.out, this.this$0.dir.resolve(this.this$0.pkgName.replace('.', '/') + '/' + n + ".java"));
            }
        };
    }

    public void visitEnd() {
        this.file.pop();
        this.file.s("}");
        this.file.pop();
        this.file.s("}");
        ASMifierFileV.write(this.file, this.dir.resolve(this.pkgName.replace('.', '/') + "/Main.java"));
    }
}

