/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.vcs.internal.services;

import java.util.Collection;
import javax.inject.Inject;
import org.gradle.StartParameter;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentResolvers;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ResolverProviderFactory;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentRegistry;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.notations.ModuleIdentifierNotationConverter;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.PublicBuildPath;
import org.gradle.internal.service.Provides;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.ServiceRegistrationProvider;
import org.gradle.internal.service.scopes.AbstractGradleModuleServices;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.vcs.SourceControl;
import org.gradle.vcs.VcsMappings;
import org.gradle.vcs.internal.DefaultSourceControl;
import org.gradle.vcs.internal.DefaultVcsMappingFactory;
import org.gradle.vcs.internal.DefaultVcsMappings;
import org.gradle.vcs.internal.DefaultVcsMappingsStore;
import org.gradle.vcs.internal.VcsDirectoryLayout;
import org.gradle.vcs.internal.VcsMappingFactory;
import org.gradle.vcs.internal.VcsMappingsStore;
import org.gradle.vcs.internal.VcsResolver;
import org.gradle.vcs.internal.VersionControlRepositoryConnectionFactory;
import org.gradle.vcs.internal.VersionControlSpecFactory;
import org.gradle.vcs.internal.resolver.DefaultVcsVersionWorkingDirResolver;
import org.gradle.vcs.internal.resolver.OfflineVcsVersionWorkingDirResolver;
import org.gradle.vcs.internal.resolver.OncePerBuildInvocationVcsVersionWorkingDirResolver;
import org.gradle.vcs.internal.resolver.PersistentVcsMetadataCache;
import org.gradle.vcs.internal.resolver.VcsDependencyResolver;
import org.gradle.vcs.internal.resolver.VcsVersionSelectionCache;
import org.gradle.vcs.internal.resolver.VcsVersionWorkingDirResolver;
import org.gradle.vcs.internal.services.DefaultVersionControlRepositoryFactory;
import org.gradle.vcs.internal.services.DefaultVersionControlSpecFactory;

public class VersionControlServices
extends AbstractGradleModuleServices {
    public void registerBuildTreeServices(ServiceRegistration registration) {
        registration.addProvider((ServiceRegistrationProvider)new VersionControlBuildTreeServices());
    }

    public void registerBuildSessionServices(ServiceRegistration registration) {
        registration.addProvider((ServiceRegistrationProvider)new VersionControlBuildSessionServices());
    }

    public void registerBuildServices(ServiceRegistration registration) {
        registration.addProvider((ServiceRegistrationProvider)new VersionControlBuildServices());
    }

    public void registerSettingsServices(ServiceRegistration registration) {
        registration.addProvider((ServiceRegistrationProvider)new VersionControlSettingsServices());
    }

    private static class VersionControlBuildTreeServices
    implements ServiceRegistrationProvider {
        private VersionControlBuildTreeServices() {
        }

        @Provides
        VcsMappingFactory createVcsMappingFactory(ObjectFactory objectFactory, StartParameter startParameter, NotationParser<String, ModuleIdentifier> notationParser, VersionControlSpecFactory versionControlSpecFactory) {
            return new DefaultVcsMappingFactory(objectFactory, versionControlSpecFactory);
        }

        @Provides
        VersionControlSpecFactory createVersionControlSpecFactory(ObjectFactory objectFactory, NotationParser<String, ModuleIdentifier> notationParser) {
            return new DefaultVersionControlSpecFactory(objectFactory, notationParser);
        }

        @Provides
        VcsMappingsStore createVcsMappingsStore(VcsMappingFactory mappingFactory) {
            return new DefaultVcsMappingsStore(mappingFactory);
        }

        @Provides
        VcsResolver createVcsResolver(VcsMappingsStore mappingsStore) {
            return mappingsStore.asResolver();
        }

        @Provides
        VcsVersionSelectionCache createVersionSelectionCache() {
            return new VcsVersionSelectionCache();
        }
    }

    private static class VersionControlBuildSessionServices
    implements ServiceRegistrationProvider {
        private VersionControlBuildSessionServices() {
        }

        @Provides
        NotationParser<String, ModuleIdentifier> createModuleIdParser(ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
            return NotationParserBuilder.builder(String.class, ModuleIdentifier.class).typeDisplayName("a module identifier").fromCharSequence((NotationConverter)new ModuleIdentifierNotationConverter(moduleIdentifierFactory)).toComposite();
        }

        @Provides
        void configure(ServiceRegistration registration) {
            registration.add(VersionControlRepositoryConnectionFactory.class, DefaultVersionControlRepositoryFactory.class);
            registration.add(VcsDirectoryLayout.class);
            registration.add(PersistentVcsMetadataCache.class);
        }
    }

    private static class VersionControlBuildServices
    implements ServiceRegistrationProvider {
        private VersionControlBuildServices() {
        }

        @Provides
        void configure(ServiceRegistration registration) {
            registration.add(ResolverProviderFactory.class, VcsResolverFactory.class);
        }

        @Provides
        VcsVersionWorkingDirResolver createVcsVersionWorkingDirResolver(VersionSelectorScheme versionSelectorScheme, VersionComparator versionComparator, VersionParser versionParser, VcsVersionSelectionCache versionSelectionCache, PersistentVcsMetadataCache persistentCache, StartParameter startParameter) {
            VcsVersionWorkingDirResolver workingDirResolver = startParameter.isOffline() ? new OfflineVcsVersionWorkingDirResolver(persistentCache) : new DefaultVcsVersionWorkingDirResolver(versionSelectorScheme, versionComparator, versionParser, versionSelectionCache, persistentCache);
            return new OncePerBuildInvocationVcsVersionWorkingDirResolver(versionSelectionCache, workingDirResolver);
        }
    }

    private static class VersionControlSettingsServices
    implements ServiceRegistrationProvider {
        private VersionControlSettingsServices() {
        }

        @Provides
        VcsMappings createVcsMappings(ObjectFactory objectFactory, VcsMappingsStore vcsMappingsStore, Gradle gradle, NotationParser<String, ModuleIdentifier> notationParser) {
            return (VcsMappings)objectFactory.newInstance(DefaultVcsMappings.class, new Object[]{vcsMappingsStore, gradle, notationParser});
        }

        @Provides
        SourceControl createSourceControl(ObjectFactory objectFactory, FileResolver fileResolver, VcsMappings vcsMappings, VersionControlSpecFactory specFactory) {
            return (SourceControl)objectFactory.newInstance(DefaultSourceControl.class, new Object[]{fileResolver, vcsMappings, specFactory});
        }
    }

    protected static class VcsResolverFactory
    implements ResolverProviderFactory {
        private final VcsResolver vcsResolver;
        private final BuildStateRegistry buildRegistry;
        private final PublicBuildPath publicBuildPath;
        private final VersionControlRepositoryConnectionFactory versionControlSystemFactory;
        private final VcsVersionWorkingDirResolver workingDirResolver;

        @Inject
        public VcsResolverFactory(VcsResolver vcsResolver, BuildStateRegistry buildRegistry, PublicBuildPath publicBuildPath, VersionControlRepositoryConnectionFactory versionControlSystemFactory, VcsVersionWorkingDirResolver workingDirResolver) {
            this.vcsResolver = vcsResolver;
            this.buildRegistry = buildRegistry;
            this.publicBuildPath = publicBuildPath;
            this.versionControlSystemFactory = versionControlSystemFactory;
            this.workingDirResolver = workingDirResolver;
        }

        public void create(Collection<ComponentResolvers> resolvers, LocalComponentRegistry localComponentRegistry) {
            if (this.vcsResolver.hasRules()) {
                resolvers.add(new VcsDependencyResolver(localComponentRegistry, this.vcsResolver, this.versionControlSystemFactory, this.buildRegistry, this.workingDirResolver, this.publicBuildPath));
            }
        }
    }
}

